/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.annotation;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import org.atmosphere.annotation.AnnotationUtil;
import org.atmosphere.annotation.Processor;
import org.atmosphere.config.AtmosphereAnnotation;
import org.atmosphere.config.managed.AnnotationServiceInterceptor;
import org.atmosphere.config.managed.ManagedAtmosphereHandler;
import org.atmosphere.config.service.ManagedService;
import org.atmosphere.cpr.Action;
import org.atmosphere.cpr.AtmosphereConfig;
import org.atmosphere.cpr.AtmosphereFramework;
import org.atmosphere.cpr.AtmosphereHandler;
import org.atmosphere.cpr.AtmosphereInterceptor;
import org.atmosphere.cpr.AtmosphereResource;
import org.atmosphere.cpr.AtmosphereResourceEventListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@AtmosphereAnnotation(value=ManagedService.class)
public class ManagedServiceProcessor
implements Processor {
    private static final Logger logger = LoggerFactory.getLogger(ManagedServiceProcessor.class);

    @Override
    public void handle(AtmosphereFramework framework, Class<? extends Annotation> annotation, Class<?> discoveredClass) {
        try {
            Class<? extends AtmosphereInterceptor>[] interceptors;
            Class<?> aClass = discoveredClass;
            ManagedService a = aClass.getAnnotation(ManagedService.class);
            ArrayList<AtmosphereInterceptor> l = new ArrayList<AtmosphereInterceptor>();
            AnnotationUtil.atmosphereConfig(a.atmosphereConfig(), framework);
            framework.setDefaultBroadcasterClassName(a.broadcaster().getName());
            AnnotationUtil.filters(a.broadcastFilters(), framework);
            final Class[] listeners = a.listeners();
            if (listeners.length > 0) {
                try {
                    AtmosphereInterceptor ai = new AtmosphereInterceptor(){

                        @Override
                        public void configure(AtmosphereConfig config) {
                        }

                        @Override
                        public Action inspect(AtmosphereResource r) {
                            for (Class l : listeners) {
                                try {
                                    r.addEventListener((AtmosphereResourceEventListener)l.newInstance());
                                }
                                catch (Throwable e) {
                                    logger.warn("", e);
                                }
                            }
                            return Action.CONTINUE;
                        }

                        @Override
                        public void postInspect(AtmosphereResource r) {
                        }

                        public String toString() {
                            return "@ManagedService Event Listeners";
                        }
                    };
                    l.add(ai);
                }
                catch (Throwable e) {
                    logger.warn("", e);
                }
            }
            Object c = aClass.newInstance();
            ManagedAtmosphereHandler handler = new ManagedAtmosphereHandler(c);
            for (Class<? extends AtmosphereInterceptor> i : interceptors = a.interceptors()) {
                try {
                    AtmosphereInterceptor ai = AnnotationServiceInterceptor.class.isAssignableFrom(i) ? new AnnotationServiceInterceptor((ManagedAtmosphereHandler)ManagedAtmosphereHandler.class.cast(handler)) : i.newInstance();
                    l.add(ai);
                }
                catch (Throwable e) {
                    logger.warn("", e);
                }
            }
            framework.addAtmosphereHandler(a.path(), (AtmosphereHandler)handler, l);
        }
        catch (Throwable e) {
            logger.warn("", e);
        }
    }
}

