/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.annotation;

import org.atmosphere.cpr.AtmosphereFramework;
import org.atmosphere.cpr.AtmosphereInterceptor;
import org.atmosphere.cpr.BroadcastFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnnotationUtil {
    public static final Logger logger = LoggerFactory.getLogger(AnnotationUtil.class);

    public static void interceptors(Class<? extends AtmosphereInterceptor>[] interceptors, AtmosphereFramework framework) {
        for (Class<? extends AtmosphereInterceptor> i : interceptors) {
            try {
                framework.interceptor(i.newInstance());
            }
            catch (Throwable e) {
                logger.warn("", e);
            }
        }
    }

    public static void filters(Class<? extends BroadcastFilter>[] bf, AtmosphereFramework framework) throws IllegalAccessException, InstantiationException {
        for (Class<? extends BroadcastFilter> b : bf) {
            framework.broadcasterFilters(b.newInstance());
        }
    }

    public static void atmosphereConfig(String[] m, AtmosphereFramework framework) {
        for (String s : m) {
            String[] nv = s.split("=");
            framework.addInitParameter(nv[0], nv[1]);
        }
    }
}

