/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.util;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import org.atmosphere.cpr.ApplicationConfig;
import org.atmosphere.cpr.AtmosphereConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecutorsFactory {
    private static final Logger logger = LoggerFactory.getLogger(ExecutorsFactory.class);

    public static ExecutorService getMessageDispatcher(AtmosphereConfig config, final String name) {
        boolean isExecutorShared;
        final boolean shared = config.framework().isShareExecutorServices();
        boolean bl = isExecutorShared = shared;
        if (!shared || config.properties().get("executorService") == null) {
            int numberOfMessageProcessingThread = -1;
            String s = config.getInitParameter(ApplicationConfig.BROADCASTER_MESSAGE_PROCESSING_THREADPOOL_MAXSIZE);
            if (s != null) {
                numberOfMessageProcessingThread = Integer.parseInt(s);
            }
            if (isExecutorShared && numberOfMessageProcessingThread == 1) {
                logger.warn("Not enough numberOfMessageProcessingThread for a shareable thread pool {}, Setting it to a newCachedThreadPool", (Object)numberOfMessageProcessingThread);
                numberOfMessageProcessingThread = -1;
            }
            ExecutorService messageService = numberOfMessageProcessingThread == -1 ? Executors.newCachedThreadPool(new ThreadFactory(){
                private final AtomicInteger count = new AtomicInteger();

                @Override
                public Thread newThread(Runnable runnable) {
                    Thread t = new Thread(runnable, (shared ? "Atmosphere-Shared" : name) + "-DispatchOp-" + this.count.getAndIncrement());
                    t.setDaemon(true);
                    return t;
                }
            }) : Executors.newFixedThreadPool(numberOfMessageProcessingThread, new ThreadFactory(){
                private final AtomicInteger count = new AtomicInteger();

                @Override
                public Thread newThread(Runnable runnable) {
                    Thread t = new Thread(runnable, (shared ? "Atmosphere-Shared" : name) + "-DispatchOp-" + this.count.getAndIncrement());
                    t.setDaemon(true);
                    return t;
                }
            });
            if (shared) {
                config.properties().put("executorService", messageService);
            }
            return messageService;
        }
        return (ExecutorService)config.properties().get("executorService");
    }

    public static ExecutorService getAsyncOperationExecutor(AtmosphereConfig config, final String name) {
        boolean isAsyncExecutorShared;
        final boolean shared = config.framework().isShareExecutorServices();
        boolean bl = isAsyncExecutorShared = shared;
        if (!shared || config.properties().get("asyncWriteService") == null) {
            int numberOfAsyncThread = -1;
            String s = config.getInitParameter(ApplicationConfig.BROADCASTER_ASYNC_WRITE_THREADPOOL_MAXSIZE);
            if (s != null) {
                numberOfAsyncThread = Integer.parseInt(s);
            }
            if (isAsyncExecutorShared && numberOfAsyncThread == 1) {
                logger.warn("Not enough numberOfAsyncThread for a shareable thread pool {}, Setting it to a newCachedThreadPool", (Object)numberOfAsyncThread);
                numberOfAsyncThread = -1;
            }
            ExecutorService asyncWriteService = numberOfAsyncThread == -1 ? Executors.newCachedThreadPool(new ThreadFactory(){
                private final AtomicInteger count = new AtomicInteger();

                @Override
                public Thread newThread(Runnable runnable) {
                    Thread t = new Thread(runnable, (shared ? "Atmosphere-Shared" : name) + "-AsyncOp-" + this.count.getAndIncrement());
                    t.setDaemon(true);
                    return t;
                }
            }) : Executors.newFixedThreadPool(numberOfAsyncThread, new ThreadFactory(){
                private final AtomicInteger count = new AtomicInteger();

                @Override
                public Thread newThread(Runnable runnable) {
                    Thread t = new Thread(runnable, (shared ? "Atmosphere-Shared" : name) + "-AsyncOp-" + this.count.getAndIncrement());
                    t.setDaemon(true);
                    return t;
                }
            });
            if (shared) {
                config.properties().put("asyncWriteService", asyncWriteService);
            }
            return asyncWriteService;
        }
        return (ExecutorService)config.properties().get("asyncWriteService");
    }

    public static ScheduledExecutorService getScheduler(AtmosphereConfig config) {
        boolean shared = config.framework().isShareExecutorServices();
        if (!shared || config.properties().get("scheduler") == null) {
            ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(Runtime.getRuntime().availableProcessors(), new ThreadFactory(){
                private final AtomicInteger count = new AtomicInteger();

                @Override
                public Thread newThread(Runnable runnable) {
                    Thread t = new Thread(runnable, "Atmosphere-Scheduler-" + this.count.getAndIncrement());
                    t.setDaemon(true);
                    return t;
                }
            });
            if (shared) {
                config.properties().put("scheduler", scheduler);
            }
            return scheduler;
        }
        return (ScheduledExecutorService)config.properties().get("scheduler");
    }
}

