/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.config.managed;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import javax.servlet.Servlet;
import org.atmosphere.config.managed.ManagedAtmosphereHandler;
import org.atmosphere.config.service.AtmosphereHandlerService;
import org.atmosphere.config.service.ManagedService;
import org.atmosphere.config.service.MeteorService;
import org.atmosphere.config.service.Singleton;
import org.atmosphere.cpr.Action;
import org.atmosphere.cpr.AtmosphereConfig;
import org.atmosphere.cpr.AtmosphereFramework;
import org.atmosphere.cpr.AtmosphereHandler;
import org.atmosphere.cpr.AtmosphereInterceptor;
import org.atmosphere.cpr.AtmosphereRequest;
import org.atmosphere.cpr.AtmosphereResource;
import org.atmosphere.cpr.Broadcaster;
import org.atmosphere.cpr.FrameworkConfig;
import org.atmosphere.handler.AnnotatedProxy;
import org.atmosphere.handler.ReflectorServletProcessor;
import org.atmosphere.interceptor.BroadcastOnPostAtmosphereInterceptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnnotationServiceInterceptor
extends BroadcastOnPostAtmosphereInterceptor {
    private static final Logger logger = LoggerFactory.getLogger(AnnotationServiceInterceptor.class);
    private ManagedAtmosphereHandler proxy;
    private AtmosphereConfig config;
    private boolean wildcardMapping = false;

    public AnnotationServiceInterceptor(ManagedAtmosphereHandler proxy) {
        this.proxy = proxy;
    }

    @Override
    public void configure(AtmosphereConfig config) {
        this.config = config;
        this.optimizeMapping();
    }

    @Override
    public Action inspect(AtmosphereResource r) {
        if (!this.wildcardMapping) {
            return Action.CONTINUE;
        }
        this.mapAnnotatedService(r.getRequest(), (AtmosphereFramework.AtmosphereHandlerWrapper)r.getRequest().getAttribute(FrameworkConfig.ATMOSPHERE_HANDLER_WRAPPER));
        return Action.CONTINUE;
    }

    protected void optimizeMapping() {
        for (String w : this.config.handlers().keySet()) {
            if (!w.contains("{") || !w.contains("}")) continue;
            this.wildcardMapping = true;
        }
    }

    public boolean wildcardMapping() {
        return this.wildcardMapping;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void mapAnnotatedService(AtmosphereRequest request, AtmosphereFramework.AtmosphereHandlerWrapper w) {
        Broadcaster b = w.broadcaster;
        String pathInfo = null;
        try {
            pathInfo = request.getPathInfo();
        }
        catch (IllegalStateException ex) {
            // empty catch block
        }
        String path = pathInfo != null ? request.getServletPath() + pathInfo : request.getServletPath();
        if (path == null || path.isEmpty()) {
            path = "/";
        }
        if (b.getID().contains("{")) {
            this.config.getBroadcasterFactory().remove(b.getID());
        }
        Map<String, AtmosphereFramework.AtmosphereHandlerWrapper> map = this.config.handlers();
        synchronized (map) {
            if (this.config.handlers().get(path) == null) {
                Servlet s;
                String targetPath;
                String targetPath2;
                AnnotatedProxy ap;
                if (AnnotatedProxy.class.isAssignableFrom(w.atmosphereHandler.getClass()) && (ap = (AnnotatedProxy)AnnotatedProxy.class.cast(w.atmosphereHandler)).target().getClass().getAnnotation(ManagedService.class) != null && (targetPath2 = ap.target().getClass().getAnnotation(ManagedService.class).path()).indexOf("{") != -1 && targetPath2.indexOf("}") != -1) {
                    try {
                        Map<String, AtmosphereFramework.AtmosphereHandlerWrapper> map2 = this.config.handlers();
                        synchronized (map2) {
                            boolean singleton;
                            boolean bl = singleton = ap.target().getClass().getAnnotation(Singleton.class) != null;
                            if (!singleton) {
                                ManagedAtmosphereHandler h = (ManagedAtmosphereHandler)w.atmosphereHandler.getClass().getConstructor(Object.class).newInstance(ap.target().getClass().newInstance());
                                AnnotationServiceInterceptor m = null;
                                for (AtmosphereInterceptor i : w.interceptors) {
                                    if (!AnnotationServiceInterceptor.class.isAssignableFrom(i.getClass())) continue;
                                    m = (AnnotationServiceInterceptor)AnnotationServiceInterceptor.class.cast(i);
                                    break;
                                }
                                ArrayList<AtmosphereInterceptor> interceptors = new ArrayList<AtmosphereInterceptor>();
                                interceptors.addAll(w.interceptors);
                                interceptors.remove(m);
                                interceptors.add(new AnnotationServiceInterceptor(h));
                                this.config.framework().addAtmosphereHandler(path, (AtmosphereHandler)h, interceptors);
                            } else {
                                this.config.framework().addAtmosphereHandler(path, w.atmosphereHandler);
                            }
                        }
                        request.setAttribute(FrameworkConfig.NEW_MAPPING, "true");
                    }
                    catch (Throwable e) {
                        logger.warn("Unable to create AtmosphereHandler", e);
                    }
                }
                if (w.atmosphereHandler.getClass().getAnnotation(AtmosphereHandlerService.class) != null && (targetPath = w.atmosphereHandler.getClass().getAnnotation(AtmosphereHandlerService.class).path()).indexOf("{") != -1 && targetPath.indexOf("}") != -1) {
                    try {
                        boolean singleton;
                        boolean bl = singleton = w.atmosphereHandler.getClass().getAnnotation(Singleton.class) != null;
                        if (!singleton) {
                            this.config.framework().addAtmosphereHandler(path, (AtmosphereHandler)w.atmosphereHandler.getClass().newInstance());
                        } else {
                            this.config.framework().addAtmosphereHandler(path, w.atmosphereHandler);
                        }
                        request.setAttribute(FrameworkConfig.NEW_MAPPING, "true");
                    }
                    catch (Throwable e) {
                        logger.warn("Unable to create AtmosphereHandler", e);
                    }
                }
                if (ReflectorServletProcessor.class.isAssignableFrom(w.atmosphereHandler.getClass()) && (s = ((ReflectorServletProcessor)ReflectorServletProcessor.class.cast(w.atmosphereHandler)).getServlet()).getClass().getAnnotation(MeteorService.class) != null && (targetPath2 = s.getClass().getAnnotation(MeteorService.class).path()).indexOf("{") != -1 && targetPath2.indexOf("}") != -1) {
                    try {
                        boolean singleton;
                        boolean bl = singleton = s.getClass().getAnnotation(Singleton.class) != null;
                        if (!singleton) {
                            ReflectorServletProcessor r = new ReflectorServletProcessor();
                            r.setServlet((Servlet)s.getClass().newInstance());
                            r.init(this.config.getServletConfig());
                            this.config.framework().addAtmosphereHandler(path, r);
                        } else {
                            this.config.framework().addAtmosphereHandler(path, w.atmosphereHandler);
                        }
                        request.setAttribute(FrameworkConfig.NEW_MAPPING, "true");
                    }
                    catch (Throwable e) {
                        logger.warn("Unable to create AtmosphereHandler", e);
                    }
                }
            }
        }
    }

    @Override
    public void postInspect(AtmosphereResource r) {
        if (this.proxy != null && r.getRequest().getMethod().equalsIgnoreCase("POST")) {
            StringBuilder b = this.read(r);
            if (b.length() > 0) {
                Object o = null;
                try {
                    o = this.proxy.invoke(b.toString());
                }
                catch (IOException e) {
                    logger.error("", (Throwable)e);
                }
                if (o != null) {
                    r.getBroadcaster().broadcast(o);
                }
            } else {
                logger.warn("{} received an empty body", (Object)AnnotationServiceInterceptor.class.getSimpleName());
            }
        }
    }
}

