/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.websocket;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.atmosphere.cpr.AsyncIOWriter;
import org.atmosphere.cpr.AtmosphereConfig;
import org.atmosphere.cpr.AtmosphereInterceptorWriter;
import org.atmosphere.cpr.AtmosphereResource;
import org.atmosphere.cpr.AtmosphereResourceImpl;
import org.atmosphere.cpr.AtmosphereResponse;
import org.atmosphere.util.ByteArrayAsyncWriter;
import org.atmosphere.websocket.WebSocketHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class WebSocket
extends AtmosphereInterceptorWriter {
    protected static final Logger logger = LoggerFactory.getLogger(WebSocket.class);
    public static final String WEBSOCKET_INITIATED = WebSocket.class.getName() + ".initiated";
    public static final String WEBSOCKET_SUSPEND = WebSocket.class.getName() + ".suspend";
    public static final String WEBSOCKET_RESUME = WebSocket.class.getName() + ".resume";
    public static final String WEBSOCKET_ACCEPT_DONE = WebSocket.class.getName() + ".acceptDone";
    private AtmosphereResource r;
    protected long lastWrite = 0L;
    protected final boolean binaryWrite;
    private final ByteArrayAsyncWriter buffer = new ByteArrayAsyncWriter();
    private final AtomicBoolean firstWrite = new AtomicBoolean(false);
    private final AtmosphereConfig config;
    private WebSocketHandler webSocketHandler;

    public WebSocket(AtmosphereConfig config) {
        String s = config.getInitParameter("org.atmosphere.websocket.binaryWrite");
        this.binaryWrite = s != null && Boolean.parseBoolean(s);
        this.config = config;
    }

    public AtmosphereConfig config() {
        return this.config;
    }

    protected WebSocket webSocketHandler(WebSocketHandler webSocketHandler) {
        this.webSocketHandler = webSocketHandler;
        return this;
    }

    protected WebSocketHandler webSocketHandler() {
        return this.webSocketHandler;
    }

    public WebSocket resource(AtmosphereResource r) {
        if (this.r != null && r != null) {
            ((AtmosphereResourceImpl)AtmosphereResourceImpl.class.cast(r)).cloneState(this.r);
        }
        this.r = r;
        return this;
    }

    public AtmosphereResource resource() {
        return this.r;
    }

    public long lastWriteTimeStampInMilliseconds() {
        return this.lastWrite == -1L ? System.currentTimeMillis() : this.lastWrite;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected byte[] transform(byte[] b, int offset, int length) throws IOException {
        AtmosphereResponse response = this.r.getResponse();
        AsyncIOWriter a = response.getAsyncIOWriter();
        try {
            response.asyncIOWriter(this.buffer);
            this.invokeInterceptor(response, b, offset, length);
            byte[] byArray = this.buffer.stream().toByteArray();
            return byArray;
        }
        finally {
            this.buffer.close(null);
            response.asyncIOWriter(a);
        }
    }

    @Override
    public WebSocket write(AtmosphereResponse r, String data) throws IOException {
        boolean transform;
        this.firstWrite.set(true);
        if (!this.isOpen()) {
            throw new IOException("Connection remotely closed");
        }
        logger.trace("WebSocket.write()");
        boolean bl = transform = this.filters.size() > 0 && r.getStatus() < 400;
        if (this.binaryWrite) {
            byte[] b = data.getBytes(this.resource().getResponse().getCharacterEncoding());
            if (transform) {
                b = this.transform(b, 0, b.length);
            }
            if (b != null) {
                this.write(b, 0, b.length);
            }
        } else {
            if (transform) {
                byte[] b = data.getBytes(this.resource().getResponse().getCharacterEncoding());
                data = new String(this.transform(b, 0, b.length), r.getCharacterEncoding());
            }
            if (data != null) {
                this.write(data);
            }
        }
        this.lastWrite = System.currentTimeMillis();
        return this;
    }

    @Override
    public WebSocket write(AtmosphereResponse r, byte[] data) throws IOException {
        return this.write(r, data, 0, data.length);
    }

    @Override
    public WebSocket write(AtmosphereResponse r, byte[] b, int offset, int length) throws IOException {
        boolean transform;
        this.firstWrite.set(true);
        if (!this.isOpen()) {
            throw new IOException("Connection remotely closed");
        }
        logger.trace("WebSocket.write()");
        boolean bl = transform = this.filters.size() > 0 && r.getStatus() < 400;
        if (this.binaryWrite) {
            if (transform) {
                b = this.transform(b, offset, length);
            }
            if (b != null) {
                this.write(b, 0, length);
            }
        } else {
            String data = null;
            data = transform ? new String(this.transform(b, offset, length), r.getCharacterEncoding()) : new String(b, offset, length, r.getCharacterEncoding());
            if (data != null) {
                this.write(data);
            }
        }
        this.lastWrite = System.currentTimeMillis();
        return this;
    }

    @Override
    public WebSocket writeError(AtmosphereResponse r, int errorCode, String message) throws IOException {
        super.writeError(r, errorCode, message);
        if (!this.firstWrite.get()) {
            logger.debug("The WebSocket handshake succeeded but the dispatched URI failed {}:{}. The WebSocket connection is still open and client can continue sending messages.", (Object)message, (Object)errorCode);
        } else {
            logger.debug("{} {}", (Object)errorCode, (Object)message);
        }
        return this;
    }

    @Override
    public WebSocket redirect(AtmosphereResponse r, String location) throws IOException {
        logger.error("WebSocket Redirect not supported");
        return this;
    }

    @Override
    public void close(AtmosphereResponse r) throws IOException {
        logger.trace("WebSocket.close()");
        this.close();
    }

    @Override
    public WebSocket flush(AtmosphereResponse r) throws IOException {
        return this;
    }

    public abstract boolean isOpen();

    public abstract WebSocket write(String var1) throws IOException;

    public abstract WebSocket write(byte[] var1, int var2, int var3) throws IOException;

    public abstract void close();
}

