/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.interceptor;

import java.io.IOException;
import java.util.concurrent.Callable;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.atmosphere.cpr.Action;
import org.atmosphere.cpr.AsyncIOInterceptorAdapter;
import org.atmosphere.cpr.AsyncIOWriter;
import org.atmosphere.cpr.AtmosphereConfig;
import org.atmosphere.cpr.AtmosphereInterceptorAdapter;
import org.atmosphere.cpr.AtmosphereInterceptorWriter;
import org.atmosphere.cpr.AtmosphereResource;
import org.atmosphere.cpr.AtmosphereResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HeartbeatInterceptor
extends AtmosphereInterceptorAdapter {
    public static final String HEARTBEAT_INTERVAL_IN_SECONDS = HeartbeatInterceptor.class.getName() + ".heartbeatFrequencyInSeconds";
    private static final Logger logger = LoggerFactory.getLogger(HeartbeatInterceptor.class);
    private final ScheduledExecutorService heartBeat = Executors.newSingleThreadScheduledExecutor();
    private static final byte[] padding;
    private static final String paddingText;
    private int heartbeatFrequencyInSeconds = 30;

    @Override
    public void configure(AtmosphereConfig config) {
        String s = config.getInitParameter(HEARTBEAT_INTERVAL_IN_SECONDS);
        if (s != null) {
            this.heartbeatFrequencyInSeconds = Integer.valueOf(s);
        }
    }

    @Override
    public Action inspect(AtmosphereResource r) {
        AtmosphereResponse response = r.getResponse();
        if (r.transport().equals((Object)AtmosphereResource.TRANSPORT.STREAMING) || r.transport().equals((Object)AtmosphereResource.TRANSPORT.SSE) || r.transport().equals((Object)AtmosphereResource.TRANSPORT.WEBSOCKET)) {
            super.inspect(r);
            AsyncIOWriter writer = response.getAsyncIOWriter();
            if (AtmosphereInterceptorWriter.class.isAssignableFrom(writer.getClass())) {
                ((AtmosphereInterceptorWriter)AtmosphereInterceptorWriter.class.cast(writer)).interceptor(new AsyncIOInterceptorAdapter(){
                    Future<?> writeFuture;

                    @Override
                    public byte[] transformPayload(AtmosphereResponse response, byte[] responseDraft, byte[] data) throws IOException {
                        if (this.writeFuture != null) {
                            this.writeFuture.cancel(true);
                        }
                        return responseDraft;
                    }

                    @Override
                    public void postPayload(final AtmosphereResponse response, byte[] data, int offset, int length) {
                        this.writeFuture = HeartbeatInterceptor.this.heartBeat.schedule(new Callable<Object>(){

                            @Override
                            public Object call() throws Exception {
                                response.write(paddingText, true);
                                return null;
                            }
                        }, (long)HeartbeatInterceptor.this.heartbeatFrequencyInSeconds, TimeUnit.SECONDS);
                    }
                });
            }
        }
        return Action.CONTINUE;
    }

    public String toString() {
        return "Heartbeat Interceptor Support";
    }

    static {
        StringBuffer whitespace = new StringBuffer();
        for (int i = 0; i < 8192; ++i) {
            whitespace.append(" ");
        }
        whitespace.append("\n");
        paddingText = whitespace.toString();
        padding = paddingText.getBytes();
    }
}

