/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.client;

import org.atmosphere.cpr.Action;
import org.atmosphere.cpr.ApplicationConfig;
import org.atmosphere.cpr.AsyncIOInterceptorAdapter;
import org.atmosphere.cpr.AsyncIOWriter;
import org.atmosphere.cpr.AtmosphereConfig;
import org.atmosphere.cpr.AtmosphereInterceptorAdapter;
import org.atmosphere.cpr.AtmosphereInterceptorWriter;
import org.atmosphere.cpr.AtmosphereResource;
import org.atmosphere.cpr.AtmosphereResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageLengthInterceptor
extends AtmosphereInterceptorAdapter {
    private static final Logger logger = LoggerFactory.getLogger(MessageLengthInterceptor.class);
    private static final byte[] END = "|".getBytes();
    private byte[] end = END;
    private String endString = "|";

    @Override
    public void configure(AtmosphereConfig config) {
        String s = config.getInitParameter(ApplicationConfig.MESSAGE_DELIMITER);
        if (s != null) {
            this.end = s.getBytes();
            this.endString = s;
        }
    }

    @Override
    public Action inspect(AtmosphereResource r) {
        AtmosphereResponse response = r.getResponse();
        super.inspect(r);
        AsyncIOWriter writer = response.getAsyncIOWriter();
        if (AtmosphereInterceptorWriter.class.isAssignableFrom(writer.getClass())) {
            ((AtmosphereInterceptorWriter)AtmosphereInterceptorWriter.class.cast(writer)).interceptor(new AsyncIOInterceptorAdapter(){

                @Override
                public void postPayload(AtmosphereResponse response, byte[] data, int offset, int length) {
                    response.write(MessageLengthInterceptor.this.end);
                }
            });
        } else {
            logger.warn("Unable to apply {}. Your AsyncIOWriter must implement {}", (Object)this.getClass().getName(), (Object)AtmosphereInterceptorWriter.class.getName());
        }
        return Action.CONTINUE;
    }

    public String toString() {
        return this.endString + " End Message Interceptor";
    }
}

