/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.cpr;

import java.io.File;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import org.atmosphere.cache.BroadcasterCacheInspector;
import org.atmosphere.config.managed.AnnotationServiceInterceptor;
import org.atmosphere.config.managed.AtmosphereHandlerServiceInterceptor;
import org.atmosphere.config.managed.ManagedAtmosphereHandler;
import org.atmosphere.config.managed.MeteorServiceInterceptor;
import org.atmosphere.config.service.AsyncSupportListenerService;
import org.atmosphere.config.service.AsyncSupportService;
import org.atmosphere.config.service.AtmosphereHandlerService;
import org.atmosphere.config.service.AtmosphereInterceptorService;
import org.atmosphere.config.service.BroadcasterCacheInspectorService;
import org.atmosphere.config.service.BroadcasterCacheService;
import org.atmosphere.config.service.BroadcasterFactoryService;
import org.atmosphere.config.service.BroadcasterFilterService;
import org.atmosphere.config.service.BroadcasterListenerService;
import org.atmosphere.config.service.BroadcasterService;
import org.atmosphere.config.service.EndpoinMapperService;
import org.atmosphere.config.service.ManagedService;
import org.atmosphere.config.service.MeteorService;
import org.atmosphere.config.service.WebSocketHandlerService;
import org.atmosphere.config.service.WebSocketProcessorService;
import org.atmosphere.config.service.WebSocketProtocolService;
import org.atmosphere.cpr.Action;
import org.atmosphere.cpr.AnnotationProcessor;
import org.atmosphere.cpr.AsyncSupportListener;
import org.atmosphere.cpr.AtmosphereConfig;
import org.atmosphere.cpr.AtmosphereFramework;
import org.atmosphere.cpr.AtmosphereHandler;
import org.atmosphere.cpr.AtmosphereInterceptor;
import org.atmosphere.cpr.AtmosphereResource;
import org.atmosphere.cpr.AtmosphereResourceEventListener;
import org.atmosphere.cpr.BroadcastFilter;
import org.atmosphere.cpr.BroadcasterCache;
import org.atmosphere.cpr.BroadcasterFactory;
import org.atmosphere.cpr.BroadcasterListener;
import org.atmosphere.cpr.DefaultAsyncSupportResolver;
import org.atmosphere.cpr.WebSocketProcessorFactory;
import org.atmosphere.handler.AbstractReflectorAtmosphereHandler;
import org.atmosphere.handler.ReflectorServletProcessor;
import org.atmosphere.util.EndpointMapper;
import org.atmosphere.util.IntrospectionUtils;
import org.atmosphere.util.annotation.AnnotationDetector;
import org.atmosphere.websocket.WebSocketHandler;
import org.atmosphere.websocket.WebSocketProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultAnnotationProcessor
implements AnnotationProcessor {
    private Logger logger = LoggerFactory.getLogger(DefaultAnnotationProcessor.class);
    protected AnnotationDetector detector;

    @Override
    public AnnotationProcessor configure(final AtmosphereFramework framework) {
        AnnotationDetector.TypeReporter reporter = new AnnotationDetector.TypeReporter(){

            @Override
            public Class<? extends Annotation>[] annotations() {
                return new Class[]{AtmosphereHandlerService.class, BroadcasterCacheService.class, BroadcasterFilterService.class, BroadcasterFactoryService.class, BroadcasterService.class, MeteorService.class, WebSocketHandlerService.class, WebSocketProtocolService.class, AtmosphereInterceptorService.class, BroadcasterListenerService.class, AsyncSupportService.class, AsyncSupportListenerService.class, WebSocketProcessorService.class, BroadcasterCacheInspectorService.class, ManagedService.class, EndpoinMapperService.class};
            }

            @Override
            public void reportTypeAnnotation(Class<? extends Annotation> annotation, String className) {
                DefaultAnnotationProcessor.this.logger.info("Found Annotation in {} being scanned: {}", (Object)className, annotation);
                if (AtmosphereHandlerService.class.equals(annotation)) {
                    try {
                        Class<? extends BroadcasterCache> e;
                        Class<?> aClass = DefaultAnnotationProcessor.this.loadClass(className);
                        AtmosphereHandlerService a = aClass.getAnnotation(AtmosphereHandlerService.class);
                        framework.setDefaultBroadcasterClassName(a.broadcaster().getName());
                        Class<? extends BroadcastFilter>[] bf = a.broadcastFilters();
                        for (Class<? extends BroadcastFilter> b : bf) {
                            this.addBroadcastFilter(b.getName());
                        }
                        for (String s : a.atmosphereConfig()) {
                            String[] nv = s.split("=");
                            framework.addInitParameter(nv[0], nv[1]);
                        }
                        Class<? extends AtmosphereInterceptor>[] interceptors = a.interceptors();
                        ArrayList<AtmosphereInterceptor> l = new ArrayList<AtmosphereInterceptor>();
                        for (Class<? extends AtmosphereInterceptor> i : interceptors) {
                            try {
                                AtmosphereInterceptor ai = i.newInstance();
                                l.add(ai);
                            }
                            catch (Throwable e2) {
                                DefaultAnnotationProcessor.this.logger.warn("", e2);
                            }
                        }
                        if (a.path().contains("{")) {
                            l.add(new AtmosphereHandlerServiceInterceptor());
                        }
                        if ((e = a.broadcasterCache()) != null) {
                            framework.setBroadcasterCacheClassName(e.getName());
                        }
                        framework.sessionSupport(a.supportSession());
                        AtmosphereHandler handler = (AtmosphereHandler)aClass.newInstance();
                        for (String s : a.properties()) {
                            String[] nv = s.split("=");
                            IntrospectionUtils.setProperty(handler, nv[0], nv[1]);
                            IntrospectionUtils.addProperty(handler, nv[0], nv[1]);
                        }
                        framework.addAtmosphereHandler(a.path(), handler, l);
                    }
                    catch (Throwable e) {
                        DefaultAnnotationProcessor.this.logger.warn("", e);
                    }
                } else if (BroadcasterCacheService.class.equals(annotation)) {
                    framework.setBroadcasterCacheClassName(className);
                } else if (BroadcasterCacheInspectorService.class.equals(annotation)) {
                    try {
                        framework.addBroadcasterCacheInjector((BroadcasterCacheInspector)DefaultAnnotationProcessor.this.loadClass(className).newInstance());
                    }
                    catch (Throwable e) {
                        DefaultAnnotationProcessor.this.logger.warn("", e);
                    }
                } else if (MeteorService.class.equals(annotation)) {
                    try {
                        ReflectorServletProcessor r = new ReflectorServletProcessor();
                        r.setServletClassName(className);
                        Class<?> s = DefaultAnnotationProcessor.this.loadClass(className);
                        MeteorService m = s.getAnnotation(MeteorService.class);
                        String mapping = m.path();
                        framework.setDefaultBroadcasterClassName(m.broadcaster().getName());
                        Class<? extends BroadcastFilter>[] bf = m.broadcastFilters();
                        for (Class<? extends BroadcastFilter> b : bf) {
                            this.addBroadcastFilter(b.getName());
                        }
                        for (String i : m.atmosphereConfig()) {
                            String[] nv = i.split("=");
                            framework.addInitParameter(nv[0], nv[1]);
                        }
                        Class<? extends AtmosphereInterceptor>[] interceptors = m.interceptors();
                        ArrayList<AtmosphereInterceptor> l = new ArrayList<AtmosphereInterceptor>();
                        for (Class<? extends AtmosphereInterceptor> i : interceptors) {
                            try {
                                AtmosphereInterceptor ai = i.newInstance();
                                l.add(ai);
                            }
                            catch (Throwable e) {
                                DefaultAnnotationProcessor.this.logger.warn("", e);
                            }
                        }
                        if (m.path().contains("{")) {
                            l.add(new MeteorServiceInterceptor());
                        }
                        framework.addAtmosphereHandler(mapping, (AtmosphereHandler)r, l);
                    }
                    catch (Throwable e) {
                        DefaultAnnotationProcessor.this.logger.warn("", e);
                    }
                } else if (BroadcasterFilterService.class.equals(annotation)) {
                    try {
                        this.addBroadcastFilter(className);
                    }
                    catch (Exception e) {
                        DefaultAnnotationProcessor.this.logger.warn("", (Throwable)e);
                    }
                } else if (BroadcasterService.class.equals(annotation)) {
                    framework.setDefaultBroadcasterClassName(className);
                } else if (WebSocketHandlerService.class.equals(annotation)) {
                    try {
                        Class<? extends BroadcastFilter>[] bf;
                        Class<?> s = DefaultAnnotationProcessor.this.loadClass(className);
                        WebSocketHandlerService m = s.getAnnotation(WebSocketHandlerService.class);
                        framework.addAtmosphereHandler(m.path(), new AbstractReflectorAtmosphereHandler(){

                            @Override
                            public void onRequest(AtmosphereResource resource) throws IOException {
                            }

                            @Override
                            public void destroy() {
                            }
                        }).initWebSocket();
                        framework.setDefaultBroadcasterClassName(m.broadcaster().getName());
                        for (Class<? extends BroadcastFilter> b : bf = m.broadcastFilters()) {
                            this.addBroadcastFilter(b.getName());
                        }
                        Class<? extends BroadcasterCache> e = m.broadcasterCache();
                        if (e != null) {
                            framework.setBroadcasterCacheClassName(e.getName());
                        }
                        WebSocketProcessor p = WebSocketProcessorFactory.getDefault().getWebSocketProcessor(framework);
                        p.registerWebSocketHandler(m.path(), (WebSocketHandler)s.newInstance());
                    }
                    catch (Throwable e) {
                        DefaultAnnotationProcessor.this.logger.warn("", e);
                    }
                } else if (WebSocketProtocolService.class.equals(annotation)) {
                    framework.setWebSocketProtocolClassName(className);
                } else if (AtmosphereInterceptorService.class.equals(annotation)) {
                    try {
                        AtmosphereInterceptor a = (AtmosphereInterceptor)DefaultAnnotationProcessor.this.loadClass(className).newInstance();
                        framework.interceptor(a);
                    }
                    catch (Throwable e) {
                        DefaultAnnotationProcessor.this.logger.warn("", e);
                    }
                } else if (AsyncSupportService.class.equals(annotation)) {
                    try {
                        framework.setAsyncSupport(new DefaultAsyncSupportResolver(framework.config).newCometSupport(className));
                    }
                    catch (Throwable e) {
                        DefaultAnnotationProcessor.this.logger.warn("", e);
                    }
                } else if (AsyncSupportListenerService.class.equals(annotation)) {
                    try {
                        framework.asyncSupportListener((AsyncSupportListener)DefaultAnnotationProcessor.this.loadClass(className).newInstance());
                    }
                    catch (Throwable e) {
                        DefaultAnnotationProcessor.this.logger.warn("", e);
                    }
                } else if (BroadcasterFactoryService.class.equals(annotation)) {
                    try {
                        Class<?> bf = DefaultAnnotationProcessor.this.loadClass(className);
                        framework.setBroadcasterFactory((BroadcasterFactory)bf.newInstance());
                        framework.configureBroadcasterFactory();
                    }
                    catch (Throwable e) {
                        DefaultAnnotationProcessor.this.logger.warn("", e);
                    }
                } else if (BroadcasterListenerService.class.equals(annotation)) {
                    try {
                        framework.addBroadcasterListener((BroadcasterListener)DefaultAnnotationProcessor.this.loadClass(className).newInstance());
                    }
                    catch (Throwable e) {
                        DefaultAnnotationProcessor.this.logger.warn("", e);
                    }
                } else if (WebSocketProcessorService.class.equals(annotation)) {
                    try {
                        framework.setWebsocketProcessorClassName(className);
                    }
                    catch (Throwable e) {
                        DefaultAnnotationProcessor.this.logger.warn("", e);
                    }
                } else if (ManagedService.class.equals(annotation)) {
                    try {
                        Class<? extends AtmosphereInterceptor>[] interceptors;
                        Class<?> aClass = DefaultAnnotationProcessor.this.loadClass(className);
                        ManagedService a = aClass.getAnnotation(ManagedService.class);
                        ArrayList<AtmosphereInterceptor> l = new ArrayList<AtmosphereInterceptor>();
                        framework.setDefaultBroadcasterClassName(a.broadcaster().getName());
                        final Class[] listeners = a.listeners();
                        try {
                            AtmosphereInterceptor ai = new AtmosphereInterceptor(){

                                @Override
                                public void configure(AtmosphereConfig config) {
                                }

                                @Override
                                public Action inspect(AtmosphereResource r) {
                                    for (Class l : listeners) {
                                        try {
                                            r.addEventListener((AtmosphereResourceEventListener)l.newInstance());
                                        }
                                        catch (Throwable e) {
                                            DefaultAnnotationProcessor.this.logger.warn("", e);
                                        }
                                    }
                                    return Action.CONTINUE;
                                }

                                @Override
                                public void postInspect(AtmosphereResource r) {
                                }

                                public String toString() {
                                    return "Managed Event Listeners";
                                }
                            };
                            l.add(ai);
                        }
                        catch (Throwable e) {
                            DefaultAnnotationProcessor.this.logger.warn("", e);
                        }
                        Object c = aClass.newInstance();
                        ManagedAtmosphereHandler handler = new ManagedAtmosphereHandler(c);
                        for (Class<? extends AtmosphereInterceptor> i : interceptors = a.interceptors()) {
                            try {
                                AtmosphereInterceptor ai = AnnotationServiceInterceptor.class.isAssignableFrom(i) ? new AnnotationServiceInterceptor((ManagedAtmosphereHandler)ManagedAtmosphereHandler.class.cast(handler)) : i.newInstance();
                                l.add(ai);
                            }
                            catch (Throwable e) {
                                DefaultAnnotationProcessor.this.logger.warn("", e);
                            }
                        }
                        framework.setBroadcasterCacheClassName(a.broadcasterCache().getName());
                        framework.addAtmosphereHandler(a.path(), (AtmosphereHandler)handler, l);
                    }
                    catch (Throwable e) {
                        DefaultAnnotationProcessor.this.logger.warn("", e);
                    }
                } else if (EndpoinMapperService.class.equals(annotation)) {
                    try {
                        framework.endPointMapper((EndpointMapper)DefaultAnnotationProcessor.this.loadClass(className).newInstance());
                    }
                    catch (Throwable e) {
                        DefaultAnnotationProcessor.this.logger.warn("", e);
                    }
                }
            }

            void addBroadcastFilter(String f) throws Exception {
                framework.broadcasterFilters((BroadcastFilter)DefaultAnnotationProcessor.this.loadClass(f).newInstance());
            }
        };
        this.detector = new AnnotationDetector(reporter);
        return this;
    }

    @Override
    public AnnotationProcessor scan(File rootDir) throws IOException {
        this.detector.detect(rootDir);
        return this;
    }

    @Override
    public AnnotationProcessor scan(String packageName) throws IOException {
        this.logger.trace("Scanning @Service annotations in {}", (Object)packageName);
        this.detector.detect(packageName);
        return this;
    }

    @Override
    public void destroy() {
        this.detector.destroy();
    }

    protected Class<?> loadClass(String className) throws Exception {
        try {
            return Thread.currentThread().getContextClassLoader().loadClass(className);
        }
        catch (Throwable t) {
            return this.getClass().getClassLoader().loadClass(className);
        }
    }
}

