/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.interceptor;

import org.atmosphere.cpr.Action;
import org.atmosphere.cpr.AsyncIOInterceptor;
import org.atmosphere.cpr.AsyncIOWriter;
import org.atmosphere.cpr.AtmosphereInterceptorAdapter;
import org.atmosphere.cpr.AtmosphereInterceptorWriter;
import org.atmosphere.cpr.AtmosphereRequest;
import org.atmosphere.cpr.AtmosphereResource;
import org.atmosphere.cpr.AtmosphereResponse;
import org.atmosphere.cpr.FrameworkConfig;

public class JSONPAtmosphereInterceptor
extends AtmosphereInterceptorAdapter {
    @Override
    public Action inspect(AtmosphereResource r) {
        final AtmosphereRequest request = r.getRequest();
        final AtmosphereResponse response = r.getResponse();
        if (r.transport().equals((Object)AtmosphereResource.TRANSPORT.JSONP)) {
            super.inspect(r);
            AsyncIOWriter writer = response.getAsyncIOWriter();
            if (AtmosphereInterceptorWriter.class.isAssignableFrom(writer.getClass())) {
                ((AtmosphereInterceptorWriter)AtmosphereInterceptorWriter.class.cast(writer)).interceptor(new AsyncIOInterceptor(){

                    String contentType() {
                        String c = response.getContentType();
                        if (c == null) {
                            c = (String)request.getAttribute(FrameworkConfig.EXPECTED_CONTENT_TYPE);
                        }
                        if (c == null) {
                            c = request.getContentType();
                        }
                        return c;
                    }

                    String callbackName() {
                        return request.getParameter("jsonpTransport");
                    }

                    @Override
                    public void intercept(AtmosphereResponse response2, String data) {
                        String contentType = this.contentType();
                        String callbackName = this.callbackName();
                        data = !data.startsWith("\"") && !contentType.contains("json") ? callbackName + "({\"message\" : \"" + data + "\"});" : callbackName + "({\"message\" :" + data + "});";
                        response2.write(data);
                    }

                    @Override
                    public void intercept(AtmosphereResponse response2, byte[] data) {
                        String contentType = this.contentType();
                        String callbackName = this.callbackName();
                        if (contentType != null && !contentType.contains("json")) {
                            response2.write(callbackName + "({\"message\" : \"").write(data).write("\"});");
                        } else {
                            response2.write(callbackName + "({\"message\" :").write(data).write("});");
                        }
                    }

                    @Override
                    public void intercept(AtmosphereResponse response2, byte[] data, int offset, int length) {
                        String contentType = this.contentType();
                        String callbackName = this.callbackName();
                        if (contentType != null && !contentType.contains("json")) {
                            response2.write(callbackName + "({\"message\" : \"").write(data, offset, length).write("\"});");
                        } else {
                            response2.write(callbackName + "({\"message\" :").write(data, offset, length).write("});");
                        }
                    }
                });
            } else {
                throw new IllegalStateException("AsyncIOWriter must be an instance of " + AsyncIOWriter.class.getName());
            }
        }
        return Action.CONTINUE;
    }

    public String toString() {
        return "JSONP Interceptor Support";
    }
}

