/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.container;

import java.io.UnsupportedEncodingException;
import org.atmosphere.container.version.Jetty8WebSocket;
import org.atmosphere.cpr.AtmosphereFramework;
import org.atmosphere.cpr.AtmosphereRequest;
import org.atmosphere.cpr.WebSocketProcessorFactory;
import org.atmosphere.websocket.WebSocketEventListener;
import org.atmosphere.websocket.WebSocketProcessor;
import org.atmosphere.websocket.WebSocketProtocol;
import org.eclipse.jetty.websocket.WebSocket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JettyWebSocketHandler
implements WebSocket,
WebSocket.OnFrame,
WebSocket.OnBinaryMessage,
WebSocket.OnTextMessage,
WebSocket.OnControl {
    private static final Logger logger = LoggerFactory.getLogger(JettyWebSocketHandler.class);
    private WebSocketProcessor webSocketProcessor;
    private final AtmosphereRequest request;
    private final AtmosphereFramework framework;
    private final WebSocketProtocol webSocketProtocol;

    public JettyWebSocketHandler(AtmosphereRequest request, AtmosphereFramework framework, WebSocketProtocol webSocketProtocol) {
        this.request = request;
        this.framework = framework;
        this.webSocketProtocol = webSocketProtocol;
    }

    public void onMessage(byte[] data, int offset, int length) {
        logger.trace("WebSocket.onMessage (bytes)");
        this.webSocketProcessor.invokeWebSocketProtocol(data, offset, length);
    }

    public boolean onControl(byte controlCode, byte[] data, int offset, int length) {
        logger.trace("WebSocket.onControl.");
        try {
            this.webSocketProcessor.notifyListener(new WebSocketEventListener.WebSocketEvent(new String(data, offset, length, "UTF-8"), WebSocketEventListener.WebSocketEvent.TYPE.CONTROL, this.webSocketProcessor.webSocket()));
        }
        catch (UnsupportedEncodingException e) {
            logger.warn("UnsupportedEncodingException", (Throwable)e);
        }
        return false;
    }

    public boolean onFrame(byte flags, byte opcode, byte[] data, int offset, int length) {
        logger.trace("WebSocket.onFrame.");
        return false;
    }

    public void onHandshake(WebSocket.FrameConnection connection) {
        logger.trace("WebSocket.onHandshake");
        try {
            this.webSocketProcessor = WebSocketProcessorFactory.getDefault().newWebSocketProcessor(new Jetty8WebSocket((WebSocket.Connection)connection, this.framework.getAtmosphereConfig()));
        }
        catch (Exception e) {
            logger.warn("failed to connect to web socket", (Throwable)e);
        }
        this.webSocketProcessor.notifyListener(new WebSocketEventListener.WebSocketEvent("", WebSocketEventListener.WebSocketEvent.TYPE.HANDSHAKE, this.webSocketProcessor.webSocket()));
    }

    public void onMessage(String data) {
        logger.trace("WebSocket.onMessage");
        this.webSocketProcessor.invokeWebSocketProtocol(data);
    }

    public void onOpen(WebSocket.Connection connection) {
        logger.trace("WebSocket.onOpen.");
        try {
            this.webSocketProcessor = WebSocketProcessorFactory.getDefault().newWebSocketProcessor(new Jetty8WebSocket(connection, this.framework.getAtmosphereConfig()));
            this.webSocketProcessor.open(this.request);
        }
        catch (Exception e) {
            logger.warn("failed to connect to web socket", (Throwable)e);
        }
    }

    public void onClose(int closeCode, String message) {
        this.request.destroy();
        if (this.webSocketProcessor == null) {
            return;
        }
        this.webSocketProcessor.close(closeCode);
    }
}

