/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.container;

import com.sun.grizzly.tcp.Request;
import com.sun.grizzly.websockets.DataFrame;
import com.sun.grizzly.websockets.DefaultWebSocket;
import com.sun.grizzly.websockets.WebSocket;
import com.sun.grizzly.websockets.WebSocketApplication;
import org.atmosphere.container.GlassFishWebSocketSupport;
import org.atmosphere.container.version.GrizzlyWebSocket;
import org.atmosphere.cpr.AtmosphereConfig;
import org.atmosphere.cpr.AtmosphereRequest;
import org.atmosphere.cpr.WebSocketProcessorFactory;
import org.atmosphere.websocket.WebSocketProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GlassFishWebSocketHandler
extends WebSocketApplication {
    private static final Logger logger = LoggerFactory.getLogger(GlassFishWebSocketSupport.class);
    private final AtmosphereConfig config;

    public GlassFishWebSocketHandler(AtmosphereConfig config) {
        this.config = config;
    }

    public void onConnect(WebSocket w) {
        super.onConnect(w);
        if (!DefaultWebSocket.class.isAssignableFrom(w.getClass())) {
            throw new IllegalStateException();
        }
        DefaultWebSocket webSocket = (DefaultWebSocket)DefaultWebSocket.class.cast(w);
        try {
            AtmosphereRequest r = AtmosphereRequest.wrap(webSocket.getRequest());
            try {
                if (r.getPathInfo().startsWith(r.getContextPath())) {
                    r.servletPath(r.getPathInfo().substring(r.getContextPath().length()));
                    r.pathInfo(null);
                }
            }
            catch (Exception e) {
                logger.trace("", (Throwable)e);
            }
            WebSocketProcessor webSocketProcessor = WebSocketProcessorFactory.getDefault().newWebSocketProcessor(new GrizzlyWebSocket((WebSocket)webSocket, this.config));
            webSocket.getRequest().setAttribute("grizzly.webSocketProcessor", (Object)webSocketProcessor);
            webSocketProcessor.open(r);
        }
        catch (Exception e) {
            logger.warn("failed to connect to web socket", (Throwable)e);
        }
    }

    public boolean isApplicationRequest(Request request) {
        return true;
    }

    public void onClose(WebSocket w, DataFrame df) {
        super.onClose(w, df);
        logger.trace("onClose {} ", (Object)w);
        DefaultWebSocket webSocket = (DefaultWebSocket)DefaultWebSocket.class.cast(w);
        if (webSocket.getRequest().getAttribute("grizzly.webSocketProcessor") != null) {
            WebSocketProcessor webSocketProcessor = (WebSocketProcessor)webSocket.getRequest().getAttribute("grizzly.webSocketProcessor");
            webSocketProcessor.close(1000);
        }
    }

    public void onMessage(WebSocket w, String text) {
        logger.trace("onMessage {} ", (Object)w);
        DefaultWebSocket webSocket = (DefaultWebSocket)DefaultWebSocket.class.cast(w);
        if (webSocket.getRequest().getAttribute("grizzly.webSocketProcessor") != null) {
            WebSocketProcessor webSocketProcessor = (WebSocketProcessor)webSocket.getRequest().getAttribute("grizzly.webSocketProcessor");
            webSocketProcessor.invokeWebSocketProtocol(text);
        }
    }

    public void onMessage(WebSocket w, byte[] bytes) {
        logger.trace("onMessage (bytes) {} ", (Object)w);
        DefaultWebSocket webSocket = (DefaultWebSocket)DefaultWebSocket.class.cast(w);
        if (webSocket.getRequest().getAttribute("grizzly.webSocketProcessor") != null) {
            WebSocketProcessor webSocketProcessor = (WebSocketProcessor)webSocket.getRequest().getAttribute("grizzly.webSocketProcessor");
            webSocketProcessor.invokeWebSocketProtocol(bytes, 0, bytes.length);
        }
    }

    public void onPing(WebSocket w, byte[] bytes) {
        logger.trace("onPing (bytes) {} ", (Object)w);
    }

    public void onPong(WebSocket w, byte[] bytes) {
        logger.trace("onPong (bytes) {} ", (Object)w);
    }

    public void onFragment(WebSocket w, byte[] bytes, boolean last) {
        logger.trace("onFragment (bytes) {} ", (Object)w);
    }

    public void onFragment(WebSocket w, String text, boolean last) {
        logger.trace("onFragment (string) {} ", (Object)w);
    }
}

