/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.client;

import org.atmosphere.cpr.Action;
import org.atmosphere.cpr.ApplicationConfig;
import org.atmosphere.cpr.AsyncIOInterceptor;
import org.atmosphere.cpr.AsyncIOWriter;
import org.atmosphere.cpr.AtmosphereConfig;
import org.atmosphere.cpr.AtmosphereInterceptorAdapter;
import org.atmosphere.cpr.AtmosphereInterceptorWriter;
import org.atmosphere.cpr.AtmosphereResource;
import org.atmosphere.cpr.AtmosphereResponse;
import org.atmosphere.websocket.WebSocket;
import org.atmosphere.websocket.WebSocketResponseFilter;

public class MessageLengthInterceptor
extends AtmosphereInterceptorAdapter {
    private static final byte[] END = "|".getBytes();
    private byte[] end = END;
    private String endString = "|";

    @Override
    public void configure(AtmosphereConfig config) {
        String s = config.getInitParameter(ApplicationConfig.MESSAGE_DELIMITER);
        if (s != null) {
            this.end = s.getBytes();
            this.endString = s;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Action inspect(AtmosphereResource r) {
        AtmosphereResponse response = r.getResponse();
        if (r.transport() != AtmosphereResource.TRANSPORT.WEBSOCKET) {
            super.inspect(r);
            AsyncIOWriter writer = response.getAsyncIOWriter();
            if (!AtmosphereInterceptorWriter.class.isAssignableFrom(writer.getClass())) throw new IllegalStateException("AsyncIOWriter must be an instance of " + AsyncIOWriter.class.getName());
            ((AtmosphereInterceptorWriter)AtmosphereInterceptorWriter.class.cast(writer)).interceptor(new AsyncIOInterceptor(){

                @Override
                public void intercept(AtmosphereResponse response, String data) {
                    response.write(data + MessageLengthInterceptor.this.endString);
                }

                @Override
                public void intercept(AtmosphereResponse response, byte[] data) {
                    response.write(data).write(MessageLengthInterceptor.this.end);
                }

                @Override
                public void intercept(AtmosphereResponse response, byte[] data, int offset, int length) {
                    response.write(data, offset, length).write(MessageLengthInterceptor.this.end);
                }
            });
            return Action.CONTINUE;
        } else {
            ((WebSocket)response.getAsyncIOWriter()).webSocketResponseFilter(new WebSocketResponseFilter(){

                @Override
                public String filter(AtmosphereResponse r, String message) {
                    return message + MessageLengthInterceptor.this.endString;
                }

                @Override
                public byte[] filter(AtmosphereResponse r, byte[] message) {
                    byte[] nb = new byte[message.length + MessageLengthInterceptor.this.end.length];
                    System.arraycopy(message, 0, nb, 0, message.length);
                    System.arraycopy(MessageLengthInterceptor.this.end, 0, nb, message.length, nb.length);
                    return nb;
                }

                @Override
                public byte[] filter(AtmosphereResponse r, byte[] message, int offset, int length) {
                    byte[] nb = new byte[length + MessageLengthInterceptor.this.end.length];
                    System.arraycopy(message, offset, nb, 0, length);
                    System.arraycopy(MessageLengthInterceptor.this.end, 0, nb, length, nb.length);
                    return nb;
                }
            });
        }
        return Action.CONTINUE;
    }

    public String toString() {
        return this.endString + " End Message Interceptor";
    }
}

