/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.cpr;

import org.atmosphere.cpr.AtmosphereConfig;
import org.atmosphere.websocket.DefaultWebSocketProcessor;
import org.atmosphere.websocket.WebSocket;
import org.atmosphere.websocket.WebSocketProcessor;

public class WebSocketProcessorFactory {
    private static WebSocketProcessorFactory factory;
    private final AtmosphereConfig config;
    private final String webSocketProcessorName;

    protected WebSocketProcessorFactory(AtmosphereConfig config) {
        this.config = config;
        factory = this;
        this.webSocketProcessorName = config.framework().getWebSocketProcessorClassName();
    }

    public static final WebSocketProcessorFactory getDefault() {
        return factory;
    }

    public WebSocketProcessor newWebSocketProcessor(WebSocket webSocket) {
        WebSocketProcessor wp = null;
        if (!this.webSocketProcessorName.equalsIgnoreCase(WebSocketProcessor.class.getName())) {
            try {
                wp = (WebSocketProcessor)Thread.currentThread().getContextClassLoader().loadClass(this.webSocketProcessorName).newInstance();
            }
            catch (Exception ex) {
                try {
                    wp = (WebSocketProcessor)this.getClass().getClassLoader().loadClass(this.webSocketProcessorName).newInstance();
                }
                catch (Exception ex2) {
                    // empty catch block
                }
            }
        }
        if (wp == null) {
            wp = new DefaultWebSocketProcessor(this.config.framework(), webSocket, this.config.framework().getWebSocketProtocol());
        }
        return wp;
    }
}

