/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.cpr;

import java.util.LinkedList;
import java.util.List;
import org.atmosphere.container.BlockingIOCometSupport;
import org.atmosphere.container.GlassFishWebSocketSupport;
import org.atmosphere.container.GlassFishv2CometSupport;
import org.atmosphere.container.Grizzly2CometSupport;
import org.atmosphere.container.GrizzlyCometSupport;
import org.atmosphere.container.JBossWebCometSupport;
import org.atmosphere.container.Jetty7CometSupport;
import org.atmosphere.container.JettyAsyncSupportWithWebSocket;
import org.atmosphere.container.JettyCometSupport;
import org.atmosphere.container.JettyServlet30AsyncSupportWithWebSocket;
import org.atmosphere.container.NettyCometSupport;
import org.atmosphere.container.Servlet30CometSupport;
import org.atmosphere.container.Tomcat7AsyncSupportWithWebSocket;
import org.atmosphere.container.Tomcat7CometSupport;
import org.atmosphere.container.Tomcat7Servlet30SupportWithWebSocket;
import org.atmosphere.container.TomcatCometSupport;
import org.atmosphere.cpr.AsyncSupport;
import org.atmosphere.cpr.AsyncSupportResolver;
import org.atmosphere.cpr.AtmosphereConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultAsyncSupportResolver
implements AsyncSupportResolver {
    private static final Logger logger = LoggerFactory.getLogger(DefaultAsyncSupportResolver.class);
    public static final String SERVLET_30 = "javax.servlet.AsyncListener";
    public static final String GLASSFISH_V2 = "com.sun.enterprise.web.PEWebContainer";
    public static final String TOMCAT_7 = "org.apache.catalina.comet.CometFilterChain";
    public static final String TOMCAT_WEBSOCKET = "org.apache.catalina.websocket.WebSocketServlet";
    public static final String TOMCAT = "org.apache.coyote.http11.Http11NioProcessor";
    public static final String JBOSS_5 = "org.jboss.";
    public static final String JETTY = "org.mortbay.util.ajax.Continuation";
    public static final String JETTY_7 = "org.eclipse.jetty.servlet.ServletContextHandler";
    public static final String JETTY_8 = "org.eclipse.jetty.continuation.Servlet3Continuation";
    public static final String GRIZZLY = "com.sun.grizzly.http.servlet.ServletAdapter";
    public static final String GRIZZLY2 = "org.glassfish.grizzly.http.servlet.ServletHandler";
    public static final String JBOSSWEB = "org.apache.catalina.connector.HttpEventImpl";
    public static final String GRIZZLY_WEBSOCKET = "com.sun.grizzly.websockets.WebSocketEngine";
    public static final String NETTY = "org.jboss.netty.channel.Channel";
    private final AtmosphereConfig config;

    public DefaultAsyncSupportResolver(AtmosphereConfig config) {
        this.config = config;
    }

    protected boolean testClassExists(String testClass) {
        try {
            return testClass != null && testClass.length() > 0 && Thread.currentThread().getContextClassLoader().loadClass(testClass) != null;
        }
        catch (ClassNotFoundException ex) {
            return false;
        }
        catch (NoClassDefFoundError ex) {
            return false;
        }
    }

    public List<Class<? extends AsyncSupport>> detectContainersPresent() {
        return new LinkedList<Class<? extends AsyncSupport>>(){
            {
                if (DefaultAsyncSupportResolver.this.testClassExists(DefaultAsyncSupportResolver.GLASSFISH_V2)) {
                    this.add(GlassFishv2CometSupport.class);
                }
                if (DefaultAsyncSupportResolver.this.testClassExists(DefaultAsyncSupportResolver.JETTY)) {
                    this.add(JettyCometSupport.class);
                }
                if (DefaultAsyncSupportResolver.this.testClassExists(DefaultAsyncSupportResolver.JETTY_7)) {
                    this.add(Jetty7CometSupport.class);
                }
                if (DefaultAsyncSupportResolver.this.testClassExists(DefaultAsyncSupportResolver.JETTY_8)) {
                    this.add(Jetty7CometSupport.class);
                }
                if (DefaultAsyncSupportResolver.this.testClassExists(DefaultAsyncSupportResolver.JBOSSWEB)) {
                    this.add(JBossWebCometSupport.class);
                }
                if (DefaultAsyncSupportResolver.this.testClassExists(DefaultAsyncSupportResolver.TOMCAT_7)) {
                    this.add(Tomcat7CometSupport.class);
                }
                if (DefaultAsyncSupportResolver.this.testClassExists(DefaultAsyncSupportResolver.TOMCAT) || DefaultAsyncSupportResolver.this.testClassExists(DefaultAsyncSupportResolver.JBOSS_5)) {
                    this.add(TomcatCometSupport.class);
                }
                if (DefaultAsyncSupportResolver.this.testClassExists(DefaultAsyncSupportResolver.GRIZZLY)) {
                    this.add(GrizzlyCometSupport.class);
                }
                if (DefaultAsyncSupportResolver.this.testClassExists(DefaultAsyncSupportResolver.GRIZZLY2)) {
                    this.add(Grizzly2CometSupport.class);
                }
                if (DefaultAsyncSupportResolver.this.testClassExists(DefaultAsyncSupportResolver.NETTY)) {
                    this.add(NettyCometSupport.class);
                }
            }
        };
    }

    public List<Class<? extends AsyncSupport>> detectWebSocketPresent(boolean useNativeIfPossible) {
        if (useNativeIfPossible) {
            return this.detectServlet3WebSocketPresent();
        }
        LinkedList<Class<? extends AsyncSupport>> l = new LinkedList<Class<? extends AsyncSupport>>(){
            {
                if (DefaultAsyncSupportResolver.this.testClassExists(DefaultAsyncSupportResolver.TOMCAT_WEBSOCKET)) {
                    this.add(Tomcat7AsyncSupportWithWebSocket.class);
                }
                if (DefaultAsyncSupportResolver.this.testClassExists(DefaultAsyncSupportResolver.JETTY_8)) {
                    this.add(JettyAsyncSupportWithWebSocket.class);
                }
                if (DefaultAsyncSupportResolver.this.testClassExists(DefaultAsyncSupportResolver.GRIZZLY_WEBSOCKET)) {
                    this.add(GlassFishWebSocketSupport.class);
                }
            }
        };
        return l;
    }

    public List<Class<? extends AsyncSupport>> detectServlet3WebSocketPresent() {
        LinkedList<Class<? extends AsyncSupport>> l = new LinkedList<Class<? extends AsyncSupport>>(){
            {
                if (DefaultAsyncSupportResolver.this.testClassExists(DefaultAsyncSupportResolver.TOMCAT_WEBSOCKET)) {
                    this.add(Tomcat7Servlet30SupportWithWebSocket.class);
                }
                if (DefaultAsyncSupportResolver.this.testClassExists(DefaultAsyncSupportResolver.JETTY_8)) {
                    this.add(JettyServlet30AsyncSupportWithWebSocket.class);
                }
            }
        };
        return l;
    }

    public AsyncSupport defaultCometSupport(boolean preferBlocking) {
        if (!preferBlocking && this.testClassExists(SERVLET_30)) {
            return new Servlet30CometSupport(this.config);
        }
        return new BlockingIOCometSupport(this.config);
    }

    public AsyncSupport newCometSupport(Class<? extends AsyncSupport> targetClass) {
        try {
            return targetClass.getDeclaredConstructor(AtmosphereConfig.class).newInstance(this.config);
        }
        catch (Exception e) {
            logger.error("failed to create comet support class: {}, error: {}", targetClass, (Object)e.getMessage());
            throw new IllegalArgumentException("Comet support class " + targetClass.getCanonicalName() + " has bad signature.", e);
        }
    }

    public AsyncSupport newCometSupport(String targetClassFQN) {
        try {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            return (AsyncSupport)cl.loadClass(targetClassFQN).getDeclaredConstructor(AtmosphereConfig.class).newInstance(this.config);
        }
        catch (Exception e) {
            logger.error("failed to create comet support class: {}, error: {}", (Object)targetClassFQN, (Object)e.getMessage());
            throw new IllegalArgumentException("Comet support class " + targetClassFQN + " has bad signature.", e);
        }
    }

    public AsyncSupport resolve(boolean useNativeIfPossible, boolean defaultToBlocking) {
        AsyncSupport servletAsyncSupport = this.defaultCometSupport(defaultToBlocking);
        if (!defaultToBlocking && (useNativeIfPossible || servletAsyncSupport.getClass().getName().equals(BlockingIOCometSupport.class.getName()))) {
            AsyncSupport nativeSupport = this.resolveNativeCometSupport(this.detectContainersPresent());
            return nativeSupport == null ? servletAsyncSupport : nativeSupport;
        }
        return servletAsyncSupport;
    }

    @Override
    public AsyncSupport resolve(boolean useNativeIfPossible, boolean defaultToBlocking, boolean useWebsocketIfPossible) {
        AsyncSupport cs;
        if (!useWebsocketIfPossible) {
            cs = this.resolve(useNativeIfPossible, defaultToBlocking);
        } else {
            List<Class<? extends AsyncSupport>> l;
            boolean use30 = false;
            String s = this.config.getInitParameter("org.atmosphere.useWebSocketAndServlet3");
            if (s != null) {
                use30 = Boolean.valueOf(s);
            }
            if ((l = this.detectWebSocketPresent(use30)).isEmpty()) {
                return this.resolve(useNativeIfPossible, defaultToBlocking);
            }
            cs = this.resolveWebSocket(l);
        }
        if (cs == null) {
            return new BlockingIOCometSupport(this.config);
        }
        return cs;
    }

    public AsyncSupport resolveWebSocket(List<Class<? extends AsyncSupport>> available) {
        if (available == null || available.isEmpty()) {
            return null;
        }
        return this.newCometSupport(available.get(0));
    }

    protected AsyncSupport resolveNativeCometSupport(List<Class<? extends AsyncSupport>> available) {
        if (available == null || available.isEmpty()) {
            return null;
        }
        if (available.size() == 1) {
            return this.newCometSupport(available.get(0));
        }
        return this.resolveMultipleNativeSupportConflict(available);
    }

    protected AsyncSupport resolveMultipleNativeSupportConflict(List<Class<? extends AsyncSupport>> available) {
        StringBuilder b = new StringBuilder("Found multiple containers, please specify which one to use: ");
        for (Class<? extends AsyncSupport> cs : available) {
            b.append(cs != null ? cs.getCanonicalName() : "null").append(", ");
        }
        b.append(" until you do, Atmosphere will use:" + available.get(0));
        logger.warn("{}", (Object)b.toString());
        return this.newCometSupport(available.get(0));
    }
}

