/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.cpr;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.atmosphere.cpr.SessionTimeoutRestorer;

public final class SessionTimeoutSupport {
    private static final String KEY = "atmosphere.session.timeout.restorer";

    public static void setupTimeout(HttpSession session) {
        if (session == null) {
            return;
        }
        SessionTimeoutSupport.bind(session, SessionTimeoutSupport.createRestorer(session));
        session.setMaxInactiveInterval(-1);
    }

    public static void restoreTimeout(HttpSession session) {
        if (session == null) {
            return;
        }
        SessionTimeoutRestorer restorer = SessionTimeoutSupport.unbind(session);
        if (restorer != null) {
            restorer.restore(session);
        }
    }

    public static void restoreTimeout(HttpServletRequest request) {
        SessionTimeoutSupport.restoreTimeout(request.getSession(false));
    }

    private static SessionTimeoutRestorer createRestorer(HttpSession session) {
        return new SessionTimeoutRestorer(session.getMaxInactiveInterval());
    }

    private static void bind(HttpSession s, SessionTimeoutRestorer r) {
        s.setAttribute(KEY, (Object)r);
    }

    private static SessionTimeoutRestorer unbind(HttpSession s) {
        if (s == null) {
            return null;
        }
        SessionTimeoutRestorer r = (SessionTimeoutRestorer)s.getAttribute(KEY);
        s.removeAttribute(KEY);
        return r;
    }
}

