/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.cache;

import org.atmosphere.cache.BroadcasterCacheBase;
import org.atmosphere.cpr.AtmosphereRequest;
import org.atmosphere.cpr.AtmosphereResource;
import org.atmosphere.cpr.AtmosphereResourceImpl;

public class HeaderBroadcasterCache
extends BroadcasterCacheBase {
    @Override
    public void cache(AtmosphereResource ar, BroadcasterCacheBase.CachedMessage cm) {
        long time = cm.next() == null ? cm.currentTime() : cm.next().currentTime();
        AtmosphereResourceImpl r = (AtmosphereResourceImpl)AtmosphereResourceImpl.class.cast(ar);
        if (r != null && r.isInScope() && !r.getResponse().isCommitted()) {
            r.getResponse().addHeader("X-Cache-Date", String.valueOf(time));
        }
    }

    @Override
    public BroadcasterCacheBase.CachedMessage retrieveLastMessage(AtmosphereResource ar) {
        AtmosphereResourceImpl r = (AtmosphereResourceImpl)AtmosphereResourceImpl.class.cast(ar);
        if (!r.isInScope()) {
            return null;
        }
        AtmosphereRequest request = r.getRequest();
        return this.retrieveUsingHeader(request.getHeader("X-Cache-Date"));
    }

    public BroadcasterCacheBase.CachedMessage retrieveUsingHeader(String dateString) {
        if (dateString == null) {
            return null;
        }
        long currentTime = Long.valueOf(dateString);
        BroadcasterCacheBase.CachedMessage prev = null;
        for (BroadcasterCacheBase.CachedMessage cm : this.queue) {
            if (cm.currentTime() > currentTime) {
                return prev;
            }
            prev = cm;
        }
        return prev;
    }
}

