/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.cpr;

import java.util.List;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.servlet.http.HttpServletRequest;
import org.atmosphere.cpr.AtmosphereResource;
import org.atmosphere.cpr.AtmosphereResourceEventListener;
import org.atmosphere.cpr.AtmosphereResourceImpl;
import org.atmosphere.cpr.BroadcastFilter;
import org.atmosphere.cpr.Broadcaster;
import org.atmosphere.cpr.BroadcasterFactory;
import org.atmosphere.cpr.DefaultBroadcaster;
import org.atmosphere.cpr.FrameworkConfig;
import org.atmosphere.cpr.Serializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Meteor {
    private static final Logger logger = LoggerFactory.getLogger(Meteor.class);
    protected static final ConcurrentHashMap<AtmosphereResource, Meteor> cache = new ConcurrentHashMap();
    private final AtmosphereResource r;
    private Object o;
    private AtomicBoolean isDestroyed = new AtomicBoolean(false);

    private Meteor(AtmosphereResource r, List<BroadcastFilter> l, Serializer s) {
        this.r = r;
        this.r.setSerializer(s);
        if (l != null) {
            for (BroadcastFilter f : l) {
                this.r.getBroadcaster().getBroadcasterConfig().addFilter(f);
            }
        }
        cache.put(this.r, this);
    }

    public static Meteor lookup(HttpServletRequest r) {
        return cache.get(r.getAttribute(FrameworkConfig.ATMOSPHERE_RESOURCE));
    }

    public static final Meteor build(HttpServletRequest r) {
        return Meteor.build(r, null);
    }

    public static final Meteor build(HttpServletRequest r, Serializer s) {
        return Meteor.build(r, null, s);
    }

    public static final Meteor build(HttpServletRequest req, List<BroadcastFilter> l, Serializer s) {
        return Meteor.build(req, Broadcaster.SCOPE.APPLICATION, l, s);
    }

    public static final Meteor build(HttpServletRequest req, Broadcaster.SCOPE scope, List<BroadcastFilter> l, Serializer s) {
        AtmosphereResource r = (AtmosphereResource)req.getAttribute(FrameworkConfig.ATMOSPHERE_RESOURCE);
        if (r == null) {
            throw new IllegalStateException("MeteorServlet not defined in web.xml");
        }
        Broadcaster b = null;
        if (scope == Broadcaster.SCOPE.REQUEST) {
            try {
                b = BroadcasterFactory.getDefault().get(DefaultBroadcaster.class, DefaultBroadcaster.class.getSimpleName() + UUID.randomUUID());
            }
            catch (Throwable t) {
                throw new RuntimeException(t);
            }
            b.setScope(scope);
            r.setBroadcaster(b);
            req.setAttribute(AtmosphereResourceImpl.SKIP_BROADCASTER_CREATION, (Object)Boolean.TRUE);
        }
        Meteor m = new Meteor(r, l, s);
        req.setAttribute(AtmosphereResourceImpl.METEOR, (Object)m);
        return m;
    }

    public Meteor suspend(long l) {
        if (this.destroyed()) {
            return null;
        }
        this.r.suspend(l);
        return this;
    }

    public Meteor resumeOnBroadcast(boolean resumeOnBroadcast) {
        this.r.resumeOnBroadcast(resumeOnBroadcast);
        return this;
    }

    public AtmosphereResource.TRANSPORT transport() {
        return this.r.transport();
    }

    public Meteor suspend(long timeout, TimeUnit timeunit) {
        if (this.destroyed()) {
            return null;
        }
        this.r.suspend(timeout, timeunit);
        return this;
    }

    public Meteor suspend(long l, boolean outputComments) {
        if (this.destroyed()) {
            return null;
        }
        this.r.suspend(l, outputComments);
        return this;
    }

    public Meteor suspend(long timeout, TimeUnit timeunit, boolean outputComments) {
        if (this.destroyed()) {
            return null;
        }
        this.r.suspend(timeout, timeunit, outputComments);
        return this;
    }

    public Meteor resume() {
        if (this.destroyed()) {
            return null;
        }
        this.r.resume();
        cache.remove(this.r);
        return this;
    }

    public Meteor broadcast(Object o) {
        if (this.destroyed()) {
            return null;
        }
        this.r.getBroadcaster().broadcast(o);
        return this;
    }

    public Meteor schedule(Object o, long period) {
        if (this.destroyed()) {
            return null;
        }
        this.r.getBroadcaster().scheduleFixedBroadcast(o, period, TimeUnit.SECONDS);
        return this;
    }

    public Meteor delayBroadadcast(Object o, long period) {
        if (this.destroyed()) {
            return null;
        }
        this.r.getBroadcaster().delayBroadcast(o, period, TimeUnit.SECONDS);
        return this;
    }

    public Broadcaster getBroadcaster() {
        if (this.destroyed()) {
            return null;
        }
        return this.r.getBroadcaster();
    }

    public void setBroadcaster(Broadcaster b) {
        if (this.destroyed()) {
            return;
        }
        this.r.setBroadcaster(b);
    }

    public Object attachement() {
        return this.o;
    }

    public void attach(Object o) {
        this.o = o;
    }

    public Meteor addListener(AtmosphereResourceEventListener e) {
        if (!this.destroyed()) {
            this.r.addEventListener(e);
        }
        return this;
    }

    public Meteor removeListener(AtmosphereResourceEventListener e) {
        if (!this.destroyed()) {
            this.r.removeEventListener(e);
        }
        return this;
    }

    public void destroy() {
        this.isDestroyed.set(true);
        cache.remove(this);
    }

    private boolean destroyed() {
        if (this.isDestroyed.get()) {
            logger.debug("This Meteor is destroyed and cannot be used.");
            return true;
        }
        return false;
    }

    public AtmosphereResource getAtmosphereResource() {
        return this.r;
    }
}

