/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.cpr;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.atmosphere.cpr.Broadcaster;
import org.atmosphere.cpr.BroadcasterFactory;
import org.atmosphere.util.uri.UriTemplate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetaBroadcaster {
    public static final String MAPPING_REGEX = "[/a-zA-Z0-9-&.*=;\\?]+";
    private static final Logger logger = LoggerFactory.getLogger(MetaBroadcaster.class);
    private static final MetaBroadcaster metaBroadcaster = new MetaBroadcaster();

    protected List<Broadcaster> broadcast(String path, Object message) {
        Collection<Broadcaster> c = BroadcasterFactory.getDefault().lookupAll();
        HashMap<String, String> m = new HashMap<String, String>();
        ArrayList<Broadcaster> l = new ArrayList<Broadcaster>();
        logger.debug("Map {}", (Object)path);
        UriTemplate t = new UriTemplate(path);
        for (Broadcaster b : c) {
            logger.debug("Trying to map {} to {}", (Object)t, (Object)b.getID());
            if (t.match((CharSequence)b.getID(), m)) {
                b.broadcast(message);
                l.add(b);
            }
            m.clear();
        }
        return l;
    }

    protected List<Broadcaster> map(String path, Object message) {
        if (path == null || path.isEmpty()) {
            throw new NullPointerException();
        }
        if (!path.startsWith("/")) {
            path = "/" + path;
        }
        if (path.contains("*")) {
            path = path.replace("*", MAPPING_REGEX);
        }
        if (path.equals("/")) {
            path = path + MAPPING_REGEX;
        }
        return this.broadcast(path, message);
    }

    public List<Broadcaster> broadcastTo(String broadcasterID, Object message) {
        return this.map(broadcasterID, message);
    }

    public static final MetaBroadcaster getDefault() {
        return metaBroadcaster;
    }
}

