/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.cpr;

import java.util.Collection;
import org.atmosphere.cpr.AsyncSupport;
import org.atmosphere.cpr.AtmosphereConfig;
import org.atmosphere.cpr.AtmosphereHandler;
import org.atmosphere.cpr.AtmosphereResource;
import org.atmosphere.cpr.AtmosphereResourceImpl;
import org.atmosphere.cpr.AtmosphereResponse;
import org.atmosphere.cpr.Broadcaster;
import org.atmosphere.cpr.BroadcasterFactory;

public final class AtmosphereResourceFactory {
    public static final AtmosphereResource create(AtmosphereConfig config, Broadcaster broadcaster, AtmosphereResponse response, AsyncSupport<?> a, AtmosphereHandler handler) {
        return new AtmosphereResourceImpl(config, broadcaster, response.request(), response, a, handler);
    }

    public static final AtmosphereResource create(AtmosphereConfig config, AtmosphereResponse response, AsyncSupport<?> a) {
        return new AtmosphereResourceImpl(config, null, response.request(), response, a, null);
    }

    public static final AtmosphereResource remove(String uuid) {
        AtmosphereResource r = AtmosphereResourceFactory.find(uuid);
        if (r != null) {
            BroadcasterFactory.getDefault().removeAllAtmosphereResource(r);
        }
        return r;
    }

    public static final AtmosphereResource find(String uuid) {
        Collection<Broadcaster> l = BroadcasterFactory.getDefault().lookupAll();
        for (Broadcaster b : l) {
            for (AtmosphereResource r : b.getAtmosphereResources()) {
                if (!r.uuid().equalsIgnoreCase(uuid)) continue;
                return r;
            }
        }
        return null;
    }
}

