/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.interceptor;

import java.io.IOException;
import org.atmosphere.cpr.Action;
import org.atmosphere.cpr.AsyncIOWriter;
import org.atmosphere.cpr.AsyncIOWriterAdapter;
import org.atmosphere.cpr.AtmosphereInterceptor;
import org.atmosphere.cpr.AtmosphereRequest;
import org.atmosphere.cpr.AtmosphereResource;
import org.atmosphere.cpr.AtmosphereResponse;
import org.atmosphere.cpr.FrameworkConfig;

public class JSONPAtmosphereInterceptor
implements AtmosphereInterceptor {
    @Override
    public Action inspect(AtmosphereResource r) {
        final AtmosphereRequest request = r.getRequest();
        final AtmosphereResponse response = r.getResponse();
        if (r.transport().equals((Object)AtmosphereResource.TRANSPORT.JSONP)) {
            response.asyncIOWriter(new AsyncIOWriterAdapter(){

                String contentType() {
                    String c = response.getContentType();
                    if (c == null) {
                        c = (String)request.getAttribute(FrameworkConfig.EXPECTED_CONTENT_TYPE);
                    }
                    return c;
                }

                String callbackName() {
                    return request.getParameter("jsonpTransport");
                }

                @Override
                public AsyncIOWriter redirect(String location) throws IOException {
                    response.sendRedirect(location);
                    return this;
                }

                @Override
                public AsyncIOWriter writeError(int errorCode, String message) throws IOException {
                    response.sendError(errorCode);
                    return this;
                }

                @Override
                public AsyncIOWriter write(String data) throws IOException {
                    String contentType = this.contentType();
                    String callbackName = this.callbackName();
                    data = contentType != null && !contentType.contains("json") ? callbackName + "({\"message\" : \"" + data + "\"})" : callbackName + "({\"message\" :" + data + "})";
                    response.write(data);
                    return this;
                }

                @Override
                public AsyncIOWriter write(byte[] data) throws IOException {
                    String contentType = this.contentType();
                    String callbackName = this.callbackName();
                    if (contentType != null && !contentType.contains("json")) {
                        response.write(callbackName + "({\"message\" : \"").write(data).write("\"})");
                    } else {
                        response.write(callbackName + "({\"message\" :").write(data).write("})");
                    }
                    return this;
                }

                @Override
                public AsyncIOWriter write(byte[] data, int offset, int length) throws IOException {
                    String contentType = this.contentType();
                    String callbackName = this.callbackName();
                    if (contentType != null && !contentType.contains("json")) {
                        response.write(callbackName + "({\"message\" : \"").write(data, offset, length).write("\"})");
                    } else {
                        response.write(callbackName + "({\"message\" :").write(data, offset, length).write("})");
                    }
                    return this;
                }

                @Override
                public void close() throws IOException {
                    response.closeStreamOrWriter();
                }

                @Override
                public AsyncIOWriter flush() throws IOException {
                    response.flushBuffer();
                    return this;
                }
            });
        }
        return Action.CONTINUE;
    }

    public String toString() {
        return "JSONP Interceptor Support";
    }
}

