/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.container;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import org.apache.catalina.websocket.MessageInbound;
import org.apache.catalina.websocket.WsOutbound;
import org.atmosphere.container.version.TomcatWebSocket;
import org.atmosphere.cpr.AtmosphereFramework;
import org.atmosphere.cpr.AtmosphereRequest;
import org.atmosphere.websocket.WebSocketEventListener;
import org.atmosphere.websocket.WebSocketProcessor;
import org.atmosphere.websocket.WebSocketProtocol;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TomcatWebSocketHandler
extends MessageInbound {
    private static final Logger logger = LoggerFactory.getLogger(TomcatWebSocketHandler.class);
    private WebSocketProcessor webSocketProcessor;
    private final AtmosphereRequest request;
    private final AtmosphereFramework framework;
    private final WebSocketProtocol webSocketProtocol;

    public TomcatWebSocketHandler(AtmosphereRequest request, AtmosphereFramework framework, WebSocketProtocol webSocketProtocol) {
        this.request = request;
        this.framework = framework;
        this.webSocketProtocol = webSocketProtocol;
    }

    protected void onOpen(WsOutbound outbound) {
        logger.trace("WebSocket.onOpen.");
        try {
            this.webSocketProcessor = new WebSocketProcessor(this.framework, new TomcatWebSocket(outbound, this.framework.getAtmosphereConfig()), this.webSocketProtocol);
            this.webSocketProcessor.dispatch(this.request);
            this.webSocketProcessor.notifyListener(new WebSocketEventListener.WebSocketEvent("", WebSocketEventListener.WebSocketEvent.TYPE.CONNECT, this.webSocketProcessor.webSocket()));
        }
        catch (Exception e) {
            logger.warn("failed to connect to web socket", (Throwable)e);
        }
    }

    protected void onClose(int closeCode) {
        this.request.destroy();
        if (this.webSocketProcessor == null) {
            return;
        }
        this.webSocketProcessor.notifyListener(new WebSocketEventListener.WebSocketEvent("", WebSocketEventListener.WebSocketEvent.TYPE.CLOSE, this.webSocketProcessor.webSocket()));
        this.webSocketProcessor.close(closeCode);
    }

    protected void onBinaryMessage(ByteBuffer message) throws IOException {
        logger.trace("WebSocket.onMessage (bytes)");
        this.webSocketProcessor.invokeWebSocketProtocol(message.array(), 0, message.array().length);
        try {
            this.webSocketProcessor.notifyListener(new WebSocketEventListener.WebSocketEvent(new String(message.array(), "UTF-8"), WebSocketEventListener.WebSocketEvent.TYPE.MESSAGE, this.webSocketProcessor.webSocket()));
        }
        catch (UnsupportedEncodingException e) {
            logger.warn("UnsupportedEncodingException", (Throwable)e);
        }
    }

    protected void onTextMessage(CharBuffer message) throws IOException {
        logger.trace("WebSocket.onMessage");
        this.webSocketProcessor.invokeWebSocketProtocol(message.toString());
        this.webSocketProcessor.notifyListener(new WebSocketEventListener.WebSocketEvent(message.toString(), WebSocketEventListener.WebSocketEvent.TYPE.MESSAGE, this.webSocketProcessor.webSocket()));
    }
}

