/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.cpr;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.servlet.AsyncContext;
import javax.servlet.DispatcherType;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.servlet.http.Part;
import org.atmosphere.cpr.FrameworkConfig;
import org.atmosphere.util.FakeHttpSession;

public class AtmosphereRequest
extends HttpServletRequestWrapper {
    private ServletInputStream bis;
    private BufferedReader br;
    private final String pathInfo;
    private final HttpSession session;
    private String methodType;
    private final Builder b;

    private AtmosphereRequest(Builder b) {
        super((HttpServletRequest)(b.request == null ? new NoOpsRequest() : b.request));
        this.pathInfo = b.pathInfo == "" ? b.request.getPathInfo() : b.pathInfo;
        FakeHttpSession fakeHttpSession = this.session = b.request == null ? new FakeHttpSession("", null, System.currentTimeMillis()) : b.request.getSession();
        if (b.inputStream == null) {
            if (b.dataBytes != null) {
                this.configureStream(b.dataBytes, b.offset, b.length, b.encoding);
            } else if (b.data != null) {
                byte[] b2 = b.data.getBytes();
                this.configureStream(b2, 0, b2.length, "UTF-8");
            }
        } else {
            this.bis = new IS(b.inputStream);
            this.br = new BufferedReader(new InputStreamReader(b.inputStream));
        }
        this.methodType = b.methodType == null ? (b.request != null ? b.request.getMethod() : "GET") : b.methodType;
        this.b = b;
    }

    private void configureStream(byte[] bytes, int offset, int length, String encoding) {
        this.bis = new ByteInputStream(bytes, offset, length);
        try {
            this.br = new BufferedReader(new StringReader(new String(bytes, offset, length, encoding)));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public String getPathInfo() {
        return this.pathInfo;
    }

    public String getMethod() {
        return this.methodType;
    }

    public String getContentType() {
        return this.b.contentType != null ? this.b.contentType : super.getContentType();
    }

    public String getServletPath() {
        return this.b.servletPath != "" ? this.b.servletPath : super.getServletPath();
    }

    public String getRequestURI() {
        return this.b.requestURI != null ? this.b.requestURI : (this.b.request != null ? super.getRequestURI() : null);
    }

    public StringBuffer getRequestURL() {
        return this.b.requestURL != null ? new StringBuffer(this.b.requestURL) : (this.b.request != null ? this.b.request.getRequestURL() : null);
    }

    public Enumeration getHeaders(String name) {
        ArrayList list = Collections.list(super.getHeaders(name));
        if (name.equalsIgnoreCase("content-type")) {
            String s = this.getContentType();
            if (s != null) {
                list.add(s);
            }
        } else {
            if (this.b.headers.get(name) != null) {
                list.add(this.b.headers.get(name));
            }
            if (this.b.request != null && list.size() == 0 && name.startsWith("X-Atmosphere") && this.b.request.getAttribute(name) != null) {
                list.add(this.b.request.getAttribute(name));
            }
        }
        return Collections.enumeration(list);
    }

    public Enumeration<String> getHeaderNames() {
        ArrayList list = Collections.list(super.getHeaderNames());
        if (this.b.contentType != null) {
            list.add("Content-Type");
        }
        if (this.b.request != null) {
            Enumeration e = this.b.request.getAttributeNames();
            while (e.hasMoreElements()) {
                String name = e.nextElement().toString();
                if (!name.startsWith("X-Atmosphere")) continue;
                list.add(name);
            }
        }
        list.addAll(this.b.headers.keySet());
        return Collections.enumeration(list);
    }

    public String getHeader(String s) {
        return this.getHeader(s, true);
    }

    public String getHeader(String s, boolean checkCase) {
        if ("content-type".equalsIgnoreCase(s)) {
            return this.getContentType();
        }
        String name = super.getHeader(s);
        if (name == null) {
            if (this.b.headers.get(s) != null) {
                return (String)this.b.headers.get(s);
            }
            if (s.startsWith("X-Atmosphere") && this.b.request != null) {
                name = (String)this.b.request.getAttribute(s);
            }
        }
        if (name == null && checkCase) {
            return this.getHeader(s.toLowerCase(), false);
        }
        if (name == null && "connection".equalsIgnoreCase(s)) {
            return "keep-alive";
        }
        return name;
    }

    public String getParameter(String s) {
        String name = super.getParameter(s);
        if (name == null && this.b.queryStrings.get(s) != null) {
            return ((String[])this.b.queryStrings.get(s))[0];
        }
        return name;
    }

    public Map<String, String[]> getParameterMap() {
        Map m = this.b.request != null ? this.b.request.getParameterMap() : Collections.emptyMap();
        for (Map.Entry e : m.entrySet()) {
            String[] s = (String[])this.b.queryStrings.get(e.getKey());
            if (s != null) {
                String[] s1 = new String[s.length + ((String[])e.getValue()).length];
                System.arraycopy(s, 0, s1, 0, s.length);
                System.arraycopy(s1, s.length + 1, e.getValue(), 0, ((String[])e.getValue()).length);
                this.b.queryStrings.put(e.getKey(), s1);
                continue;
            }
            this.b.queryStrings.put(e.getKey(), e.getValue());
        }
        return Collections.unmodifiableMap(this.b.queryStrings);
    }

    public String[] getParameterValues(String s) {
        String[] list;
        String[] stringArray = list = super.getParameterValues(s) == null ? new String[]{} : super.getParameterValues(s);
        if (this.b.queryStrings.get(s) != null) {
            String[] newList = (String[])this.b.queryStrings.get(s);
            String[] s1 = new String[list.length + newList.length];
            System.arraycopy(list, 0, s1, 0, list.length);
            System.arraycopy(s1, list.length, newList, 0, newList.length);
            list = s1;
        }
        return list;
    }

    public ServletInputStream getInputStream() throws IOException {
        return this.bis == null ? (this.b.request != null ? this.b.request.getInputStream() : null) : this.bis;
    }

    public BufferedReader getReader() throws IOException {
        return this.br == null ? (this.b.request != null ? this.b.request.getReader() : null) : this.br;
    }

    protected AtmosphereRequest headers(Map<String, String> headers) {
        headers.putAll(headers);
        return this;
    }

    public AtmosphereRequest method(String m) {
        this.methodType = m;
        return this;
    }

    public AtmosphereRequest body(String body) {
        byte[] b = body.getBytes();
        this.configureStream(b, 0, b.length, "ISO-8859-1");
        return this;
    }

    public void setAttribute(String s, Object o) {
        this.b.localAttributes.put(s, o);
        if (this.b.request != null) {
            this.b.request.setAttribute(s, o);
        }
    }

    public Object getAttribute(String s) {
        return this.b.localAttributes.get(s) != null ? this.b.localAttributes.get(s) : (this.b.request != null ? this.b.request.getAttribute(s) : null);
    }

    public void removeAttribute(String name) {
        this.b.localAttributes.remove(name);
        if (this.b.request != null) {
            this.b.request.removeAttribute(name);
        }
    }

    public Map<String, Object> attributes() {
        return this.b.localAttributes;
    }

    public HttpSession getSession() {
        return this.session;
    }

    public HttpSession getSession(boolean create) {
        return this.session;
    }

    public String getRemoteAddr() {
        return this.b.request != null ? this.b.request.getRemoteAddr() : this.b.remoteAddr;
    }

    public String getRemoteHost() {
        return this.b.request != null ? this.b.request.getRemoteHost() : this.b.remoteHost;
    }

    public int getRemotePort() {
        return this.b.request != null ? this.b.request.getRemotePort() : this.b.remotePort;
    }

    public String getLocalName() {
        return this.b.request != null ? this.b.request.getLocalName() : this.b.localName;
    }

    public int getLocalPort() {
        return this.b.request != null ? this.b.request.getLocalPort() : this.b.localPort;
    }

    public String getLocalAddr() {
        return this.b.request != null ? this.b.request.getLocalAddr() : this.b.localAddr;
    }

    public boolean dispatchRequestAsynchronously() {
        return this.b.dispatchRequestAsynchronously;
    }

    public boolean isDestroyable() {
        return this.b.destroyable;
    }

    public Enumeration<String> getAttributeNames() {
        Enumeration e;
        HashMap<String, Object> m = new HashMap<String, Object>();
        m.putAll(this.b.localAttributes);
        Enumeration enumeration = e = this.b.request != null ? this.b.request.getAttributeNames() : null;
        if (e != null) {
            while (e.hasMoreElements()) {
                String s = (String)e.nextElement();
                m.put(s, this.b.request.getAttribute(s));
            }
        }
        return Collections.enumeration(m.keySet());
    }

    public void destroy() {
        if (!this.b.destroyable) {
            return;
        }
        this.b.localAttributes.clear();
        if (this.bis != null) {
            try {
                this.bis.close();
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        if (this.br != null) {
            try {
                this.br.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.b.headers.clear();
        this.b.queryStrings.clear();
        if (this.b.request != null) {
            this.b.request.removeAttribute(FrameworkConfig.ATMOSPHERE_RESOURCE);
            this.b.request = null;
        }
    }

    public static final AtmosphereRequest wrap(HttpServletRequest request) {
        return new Builder().request(request).build();
    }

    private static final class NoOpsRequest
    implements HttpServletRequest {
        private NoOpsRequest() {
        }

        public boolean authenticate(HttpServletResponse response) throws IOException, ServletException {
            return false;
        }

        public String getAuthType() {
            return null;
        }

        public String getContextPath() {
            return "";
        }

        public Cookie[] getCookies() {
            return new Cookie[0];
        }

        public long getDateHeader(String name) {
            return 0L;
        }

        public String getHeader(String name) {
            return null;
        }

        public Enumeration<String> getHeaderNames() {
            return Collections.enumeration(Collections.emptyList());
        }

        public Enumeration<String> getHeaders(String name) {
            return Collections.enumeration(Collections.emptyList());
        }

        public int getIntHeader(String name) {
            return 0;
        }

        public String getMethod() {
            return "GET";
        }

        public Part getPart(String name) throws IOException, ServletException {
            return null;
        }

        public Collection<Part> getParts() throws IOException, ServletException {
            return Collections.emptyList();
        }

        public String getPathInfo() {
            return "";
        }

        public String getPathTranslated() {
            return "";
        }

        public String getQueryString() {
            return "";
        }

        public String getRemoteUser() {
            return null;
        }

        public String getRequestedSessionId() {
            return null;
        }

        public String getRequestURI() {
            return "";
        }

        public StringBuffer getRequestURL() {
            return new StringBuffer();
        }

        public String getServletPath() {
            return "";
        }

        public HttpSession getSession() {
            return null;
        }

        public HttpSession getSession(boolean create) {
            return null;
        }

        public Principal getUserPrincipal() {
            return null;
        }

        public boolean isRequestedSessionIdFromCookie() {
            return false;
        }

        public boolean isRequestedSessionIdFromUrl() {
            return false;
        }

        public boolean isRequestedSessionIdFromURL() {
            return false;
        }

        public boolean isRequestedSessionIdValid() {
            return false;
        }

        public boolean isUserInRole(String role) {
            return false;
        }

        public void login(String username, String password) throws ServletException {
        }

        public void logout() throws ServletException {
        }

        public AsyncContext getAsyncContext() {
            return null;
        }

        public Object getAttribute(String name) {
            return null;
        }

        public Enumeration<String> getAttributeNames() {
            return Collections.enumeration(Collections.emptyList());
        }

        public String getCharacterEncoding() {
            return null;
        }

        public int getContentLength() {
            return 0;
        }

        public String getContentType() {
            return null;
        }

        public DispatcherType getDispatcherType() {
            return null;
        }

        public ServletInputStream getInputStream() throws IOException {
            return null;
        }

        public Locale getLocale() {
            return null;
        }

        public Enumeration<Locale> getLocales() {
            return Collections.enumeration(Collections.emptyList());
        }

        public String getLocalName() {
            return null;
        }

        public int getLocalPort() {
            return 0;
        }

        public String getLocalAddr() {
            return null;
        }

        public String getParameter(String name) {
            return null;
        }

        public Map<String, String[]> getParameterMap() {
            return Collections.emptyMap();
        }

        public Enumeration<String> getParameterNames() {
            return Collections.enumeration(Collections.emptyList());
        }

        public String[] getParameterValues(String name) {
            return new String[0];
        }

        public String getProtocol() {
            return null;
        }

        public BufferedReader getReader() throws IOException {
            return null;
        }

        public String getRealPath(String path) {
            return null;
        }

        public String getRemoteAddr() {
            return null;
        }

        public String getRemoteHost() {
            return null;
        }

        public int getRemotePort() {
            return 0;
        }

        public RequestDispatcher getRequestDispatcher(String path) {
            return null;
        }

        public String getScheme() {
            return null;
        }

        public String getServerName() {
            return null;
        }

        public int getServerPort() {
            return 0;
        }

        public ServletContext getServletContext() {
            return null;
        }

        public boolean isAsyncStarted() {
            return false;
        }

        public boolean isAsyncSupported() {
            return false;
        }

        public boolean isSecure() {
            return false;
        }

        public void removeAttribute(String name) {
        }

        public void setAttribute(String name, Object o) {
        }

        public void setCharacterEncoding(String env) throws UnsupportedEncodingException {
        }

        public AsyncContext startAsync() {
            return null;
        }

        public AsyncContext startAsync(ServletRequest request, ServletResponse response) {
            return null;
        }
    }

    private static final class IS
    extends ServletInputStream {
        private final InputStream innerStream;

        public IS(InputStream innerStream) {
            this.innerStream = innerStream;
        }

        public int read() throws IOException {
            return this.innerStream.read();
        }

        public int read(byte[] bytes) throws IOException {
            return this.innerStream.read(bytes);
        }

        public int read(byte[] bytes, int i, int i1) throws IOException {
            return this.innerStream.read(bytes, i, i1);
        }

        public long skip(long l) throws IOException {
            return this.innerStream.skip(l);
        }

        public int available() throws IOException {
            return this.innerStream.available();
        }

        public void close() throws IOException {
            this.innerStream.close();
        }

        public synchronized void mark(int i) {
            this.innerStream.mark(i);
        }

        public synchronized void reset() throws IOException {
            this.innerStream.reset();
        }

        public boolean markSupported() {
            return this.innerStream.markSupported();
        }
    }

    public static final class Builder {
        private HttpServletRequest request;
        private String pathInfo = "";
        private byte[] dataBytes;
        private int offset;
        private int length;
        private String encoding = "UTF-8";
        private String methodType;
        private String contentType;
        private String data;
        private Map<String, String> headers = new HashMap<String, String>();
        private Map<String, String[]> queryStrings = new HashMap<String, String[]>();
        private String servletPath = "";
        private String requestURI;
        private String requestURL;
        private Map<String, Object> localAttributes = new HashMap<String, Object>();
        private InputStream inputStream;
        private String remoteAddr = "";
        private String remoteHost = "";
        private int remotePort = 0;
        private String localAddr = "";
        private String localName = "";
        private int localPort = 0;
        private boolean dispatchRequestAsynchronously;
        private boolean destroyable = true;

        public Builder destroyable(boolean destroyable) {
            this.destroyable = destroyable;
            return this;
        }

        public Builder headers(Map<String, String> headers) {
            this.headers = headers;
            return this;
        }

        public Builder dispatchRequestAsynchronously(boolean dispatchRequestAsynchronously) {
            this.dispatchRequestAsynchronously = dispatchRequestAsynchronously;
            return this;
        }

        public Builder remoteAddr(String remoteAddr) {
            this.remoteAddr = remoteAddr;
            return this;
        }

        public Builder remoteHost(String remoteHost) {
            this.remoteHost = remoteHost;
            return this;
        }

        public Builder remotePort(int remotePort) {
            this.remotePort = remotePort;
            return this;
        }

        public Builder localAddr(String localAddr) {
            this.localAddr = localAddr;
            return this;
        }

        public Builder localName(String localName) {
            this.localName = localName;
            return this;
        }

        public Builder localPort(int localPort) {
            this.localPort = localPort;
            return this;
        }

        public Builder attributes(Map<String, Object> attributes) {
            this.localAttributes = attributes;
            return this;
        }

        public Builder request(HttpServletRequest request) {
            this.request = request;
            return this;
        }

        public Builder servletPath(String servletPath) {
            this.servletPath = servletPath;
            return this;
        }

        public Builder requestURI(String requestURI) {
            this.requestURI = requestURI;
            return this;
        }

        public Builder requestURL(String requestURL) {
            this.requestURL = requestURL;
            return this;
        }

        public Builder pathInfo(String pathInfo) {
            this.pathInfo = pathInfo;
            return this;
        }

        public Builder body(byte[] dataBytes, int offset, int length) {
            this.dataBytes = dataBytes;
            this.offset = offset;
            this.length = length;
            return this;
        }

        public Builder encoding(String encoding) {
            this.encoding = encoding;
            return this;
        }

        public Builder method(String methodType) {
            this.methodType = methodType;
            return this;
        }

        public Builder contentType(String contentType) {
            this.contentType = contentType;
            return this;
        }

        public Builder body(String data) {
            this.data = data;
            return this;
        }

        public Builder inputStream(InputStream inputStream) {
            this.inputStream = inputStream;
            return this;
        }

        public AtmosphereRequest build() {
            return new AtmosphereRequest(this);
        }

        public Builder queryStrings(Map<String, String[]> queryStrings) {
            this.queryStrings = queryStrings;
            return this;
        }
    }

    private static final class ByteInputStream
    extends ServletInputStream {
        private final ByteArrayInputStream bis;

        public ByteInputStream(byte[] data, int offset, int length) {
            this.bis = new ByteArrayInputStream(data, offset, length);
        }

        public int read() throws IOException {
            return this.bis.read();
        }
    }
}

