/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.cpr;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import org.atmosphere.config.AtmosphereHandlerConfig;
import org.atmosphere.cpr.AtmosphereFramework;
import org.atmosphere.cpr.BroadcasterFactory;

public class AtmosphereConfig {
    private final List<AtmosphereHandlerConfig> atmosphereHandler = new ArrayList<AtmosphereHandlerConfig>();
    private boolean supportSession = true;
    private String dispatcherName = "default";
    private final AtmosphereFramework framework;
    private final Map<String, Object> properties = new HashMap<String, Object>();

    public AtmosphereConfig(AtmosphereFramework framework) {
        this.framework = framework;
    }

    public List<AtmosphereHandlerConfig> getAtmosphereHandler() {
        return this.atmosphereHandler;
    }

    public AtmosphereFramework framework() {
        return this.framework;
    }

    public ServletConfig getServletConfig() {
        return this.framework.getServletConfig();
    }

    public ServletContext getServletContext() {
        return this.framework.getServletContext();
    }

    public String getWebServerName() {
        return this.framework.getCometSupport().getContainerName();
    }

    public Map<String, AtmosphereFramework.AtmosphereHandlerWrapper> handlers() {
        return this.framework.getAtmosphereHandlers();
    }

    public String getInitParameter(String name) {
        try {
            return this.framework.getServletConfig().getInitParameter(name);
        }
        catch (Throwable ex) {
            return null;
        }
    }

    public Enumeration<String> getInitParameterNames() {
        return this.framework().getServletConfig().getInitParameterNames();
    }

    public boolean isSupportSession() {
        return this.supportSession;
    }

    public void setSupportSession(boolean supportSession) {
        this.supportSession = supportSession;
    }

    public BroadcasterFactory getBroadcasterFactory() {
        return this.framework.getBroadcasterFactory();
    }

    public String getDispatcherName() {
        return this.dispatcherName;
    }

    public void setDispatcherName(String dispatcherName) {
        this.dispatcherName = dispatcherName;
    }

    public Map<String, Object> properties() {
        return this.properties;
    }
}

