/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.client;

import org.atmosphere.cpr.AtmosphereRequest;
import org.atmosphere.cpr.AtmosphereResource;
import org.atmosphere.cpr.AtmosphereResponse;
import org.atmosphere.cpr.BroadcastFilter;
import org.atmosphere.cpr.FrameworkConfig;
import org.atmosphere.cpr.PerRequestBroadcastFilter;

public class JSONPTransportFilter
implements PerRequestBroadcastFilter {
    @Override
    public BroadcastFilter.BroadcastAction filter(AtmosphereResource r, Object message, Object originalMessage) {
        AtmosphereRequest request = r.getRequest();
        AtmosphereResponse response = r.getResponse();
        String s = request.getParameter("jsonpTransport");
        if (s != null) {
            String contentType = response.getContentType();
            if (contentType == null) {
                contentType = (String)request.getAttribute(FrameworkConfig.EXPECTED_CONTENT_TYPE);
            }
            if (contentType != null && !contentType.contains("json")) {
                String jsonPMessage = s + "({\"message\" : \"" + message + "\"})";
                return new BroadcastFilter.BroadcastAction(jsonPMessage);
            }
            String jsonPMessage = s + "({\"message\" :" + message + "})";
            return new BroadcastFilter.BroadcastAction(jsonPMessage);
        }
        return new BroadcastFilter.BroadcastAction(message);
    }

    @Override
    public BroadcastFilter.BroadcastAction filter(Object originalMessage, Object message) {
        return new BroadcastFilter.BroadcastAction(message);
    }
}

