/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.cpr;

import java.io.IOException;
import java.io.OutputStream;
import java.util.UUID;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.atmosphere.cpr.ApplicationConfig;
import org.atmosphere.cpr.AtmosphereHandler;
import org.atmosphere.cpr.AtmosphereRequest;
import org.atmosphere.cpr.AtmosphereResource;
import org.atmosphere.cpr.AtmosphereResourceEvent;
import org.atmosphere.cpr.AtmosphereResourceEventImpl;
import org.atmosphere.cpr.AtmosphereResourceEventListener;
import org.atmosphere.cpr.AtmosphereResponse;
import org.atmosphere.cpr.AtmosphereServlet;
import org.atmosphere.cpr.Broadcaster;
import org.atmosphere.cpr.BroadcasterFactory;
import org.atmosphere.cpr.CometSupport;
import org.atmosphere.cpr.DefaultBroadcaster;
import org.atmosphere.cpr.FrameworkConfig;
import org.atmosphere.cpr.Meteor;
import org.atmosphere.cpr.Serializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AtmosphereResourceImpl
implements AtmosphereResource<HttpServletRequest, HttpServletResponse> {
    private static final Logger logger = LoggerFactory.getLogger(AtmosphereResourceImpl.class);
    public static final String PRE_SUSPEND = AtmosphereResourceImpl.class.getName() + ".preSuspend";
    public static final String SKIP_BROADCASTER_CREATION = AtmosphereResourceImpl.class.getName() + ".skipBroadcasterCreation";
    public static final String METEOR = Meteor.class.getName();
    private final HttpServletRequest req;
    private final HttpServletResponse response;
    protected final AtmosphereServlet.Action action = new AtmosphereServlet.Action();
    protected Broadcaster broadcaster;
    private final AtmosphereServlet.AtmosphereConfig config;
    protected final CometSupport cometSupport;
    private Serializer serializer;
    private boolean isInScope = true;
    private final AtmosphereResourceEventImpl event;
    private String beginCompatibleData;
    private boolean useWriter = true;
    private boolean isResumed = false;
    private boolean isCancelled = false;
    private final ConcurrentLinkedQueue<AtmosphereResourceEventListener> listeners = new ConcurrentLinkedQueue();
    private final boolean injectCacheHeaders;
    private final boolean enableAccessControl;
    private final AtomicBoolean isSuspendEvent = new AtomicBoolean(false);
    private final AtmosphereHandler atmosphereHandler;
    private final boolean writeHeaders;

    public AtmosphereResourceImpl(AtmosphereServlet.AtmosphereConfig config, Broadcaster broadcaster, HttpServletRequest req, HttpServletResponse response, CometSupport cometSupport, AtmosphereHandler atmosphereHandler) {
        this.req = req;
        this.response = response;
        this.broadcaster = broadcaster;
        this.config = config;
        this.cometSupport = cometSupport;
        this.atmosphereHandler = atmosphereHandler;
        this.event = new AtmosphereResourceEventImpl(this);
        String nocache = config.getInitParameter(ApplicationConfig.NO_CACHE_HEADERS);
        this.injectCacheHeaders = nocache == null;
        String ac = config.getInitParameter(ApplicationConfig.DROP_ACCESS_CONTROL_ALLOW_ORIGIN_HEADER);
        this.enableAccessControl = ac != null ? !Boolean.parseBoolean(ac) : true;
        String wh = config.getInitParameter(FrameworkConfig.WRITE_HEADERS);
        this.writeHeaders = wh != null ? Boolean.parseBoolean(wh) : true;
        req.setAttribute(ApplicationConfig.NO_CACHE_HEADERS, (Object)this.injectCacheHeaders);
        req.setAttribute(ApplicationConfig.DROP_ACCESS_CONTROL_ALLOW_ORIGIN_HEADER, (Object)this.enableAccessControl);
        String padding = config.getInitParameter(ApplicationConfig.STREAMING_PADDING_MODE);
        this.beginCompatibleData = AtmosphereResourceImpl.createStreamingPadding(padding);
        req.setAttribute(ApplicationConfig.STREAMING_PADDING_MODE, (Object)padding);
    }

    @Override
    public AtmosphereResourceEventImpl getAtmosphereResourceEvent() {
        return this.event;
    }

    @Override
    public AtmosphereHandler getAtmosphereHandler() {
        return this.atmosphereHandler;
    }

    @Override
    public synchronized void resume() {
        try {
            if (!this.isResumed && this.isInScope) {
                this.action.type = AtmosphereServlet.Action.TYPE.RESUME;
                this.isResumed = true;
                try {
                    logger.debug("Resuming {}", (Object)this.getRequest(false));
                }
                catch (Throwable ex) {
                    return;
                }
                Broadcaster b = this.getBroadcaster(false);
                if (!b.isDestroyed() && b instanceof DefaultBroadcaster) {
                    ((DefaultBroadcaster)b).broadcastOnResume(this);
                }
                this.notifyListeners();
                this.listeners.clear();
                try {
                    if (!b.isDestroyed()) {
                        this.broadcaster.removeAtmosphereResource(this);
                    }
                }
                catch (IllegalStateException ex) {
                    logger.warn("Unable to resume", (Object)this);
                    logger.debug(ex.getMessage(), (Throwable)ex);
                }
                if (b.getScope() == Broadcaster.SCOPE.REQUEST) {
                    logger.debug("Broadcaster's scope is set to request, destroying it {}", (Object)b.getID());
                    b.destroy();
                }
                if (BroadcasterFactory.getDefault() != null) {
                    BroadcasterFactory.getDefault().removeAllAtmosphereResource(this);
                }
                try {
                    this.req.setAttribute(ApplicationConfig.RESUMED_ON_TIMEOUT, (Object)Boolean.FALSE);
                    Meteor m = (Meteor)this.req.getAttribute(METEOR);
                    if (m != null) {
                        m.destroy();
                    }
                }
                catch (Exception ex) {
                    logger.debug("Meteor resume exception: Cannot resume an already resumed/cancelled request", (Throwable)ex);
                }
                if (this.req.getAttribute(PRE_SUSPEND) == null) {
                    this.cometSupport.action(this);
                }
            } else {
                logger.debug("Cannot resume an already resumed/cancelled request {}", (Object)this);
            }
            if (AtmosphereResponse.class.isAssignableFrom(this.response.getClass())) {
                ((AtmosphereResponse)((Object)AtmosphereResponse.class.cast(this.response))).destroy();
            }
            if (AtmosphereRequest.class.isAssignableFrom(this.req.getClass())) {
                ((AtmosphereRequest)((Object)AtmosphereRequest.class.cast(this.req))).destroy();
            }
        }
        catch (Throwable t) {
            logger.trace("Wasn't able to resume a connection {}", (Object)this, (Object)t);
        }
    }

    @Override
    public void suspend() {
        this.suspend(-1L);
    }

    @Override
    public void suspend(long timeout) {
        this.suspend(timeout, true);
    }

    @Override
    public void suspend(long timeout, TimeUnit timeunit) {
        this.suspend(timeout, timeunit, true);
    }

    @Override
    public void suspend(long timeout, TimeUnit timeunit, boolean flushComment) {
        long timeoutms = -1L;
        if (timeunit != null) {
            timeoutms = TimeUnit.MILLISECONDS.convert(timeout, timeunit);
        }
        this.suspend(timeoutms, true);
    }

    @Override
    public void suspend(long timeout, boolean flushComment) {
        if (this.event.isSuspended()) {
            return;
        }
        if (this.config.isSupportSession() && this.req.getSession(false) != null && this.req.getSession().getMaxInactiveInterval() != -1 && (long)(this.req.getSession().getMaxInactiveInterval() * 1000) < timeout) {
            throw new IllegalStateException("Cannot suspend a response longer than the session timeout. Increase the value of session-timeout in web.xml");
        }
        if (this.req.getAttribute(DefaultBroadcaster.CACHED) != null) {
            this.req.removeAttribute(DefaultBroadcaster.CACHED);
            return;
        }
        if (!this.event.isResumedOnTimeout()) {
            if (this.req.getHeaders("Connection") != null && this.req.getHeaders("Connection").hasMoreElements()) {
                String[] e;
                for (String upgrade : e = ((String)this.req.getHeaders("Connection").nextElement()).toString().split(",")) {
                    if (!upgrade.trim().equalsIgnoreCase("Upgrade")) continue;
                    if (this.writeHeaders && !this.cometSupport.supportWebSocket()) {
                        this.response.addHeader("X-Atmosphere-error", "Websocket protocol not supported");
                        continue;
                    }
                    flushComment = false;
                }
            }
            if (this.writeHeaders && this.injectCacheHeaders) {
                this.response.setHeader("Expires", "-1");
                this.response.setHeader("Cache-Control", "no-store, no-cache, must-revalidate");
                this.response.setHeader("Pragma", "no-cache");
            }
            if (this.writeHeaders && this.enableAccessControl) {
                this.response.setHeader("Access-Control-Allow-Origin", "*");
                this.response.setHeader("Access-Control-Allow-Credentials", "true");
            }
            if (flushComment) {
                this.write();
            }
            this.req.setAttribute(PRE_SUSPEND, (Object)"true");
            this.action.type = AtmosphereServlet.Action.TYPE.SUSPEND;
            this.action.timeout = timeout;
            boolean isJersey = this.req.getAttribute("org.atmosphere.jersey.containerResponse") != null;
            boolean skipCreation = false;
            if (this.req.getAttribute(SKIP_BROADCASTER_CREATION) != null) {
                skipCreation = true;
            }
            if (!(skipCreation || this.broadcaster != null && this.broadcaster.getScope() != Broadcaster.SCOPE.REQUEST || isJersey)) {
                String id = this.broadcaster != null ? this.broadcaster.getID() : this.getClass().getName();
                Class<DefaultBroadcaster> clazz = this.broadcaster != null ? this.broadcaster.getClass() : DefaultBroadcaster.class;
                this.broadcaster = BroadcasterFactory.getDefault().lookup(clazz, id, false);
                if (this.broadcaster == null || this.broadcaster.getAtmosphereResources().size() > 0) {
                    this.broadcaster = BroadcasterFactory.getDefault().lookup(clazz, id + "/" + UUID.randomUUID(), true);
                }
            }
            this.broadcaster.addAtmosphereResource(this);
            this.req.removeAttribute(PRE_SUSPEND);
            this.notifyListeners();
        }
    }

    void write() {
        block7: {
            try {
                if (this.useWriter && !((Boolean)this.req.getAttribute("org.atmosphere.useStream")).booleanValue()) {
                    try {
                        this.response.getWriter();
                    }
                    catch (IllegalStateException e) {
                        return;
                    }
                    this.response.getWriter().write(this.beginCompatibleData);
                    this.response.getWriter().flush();
                    break block7;
                }
                try {
                    this.response.getOutputStream();
                }
                catch (IllegalStateException e) {
                    return;
                }
                this.response.getOutputStream().write(this.beginCompatibleData.getBytes());
                this.response.getOutputStream().flush();
            }
            catch (Throwable ex) {
                logger.warn("failed to write to response", ex);
            }
        }
    }

    public HttpServletRequest getRequest(boolean enforceScope) {
        if (enforceScope && !this.isInScope) {
            throw new IllegalStateException("Request object no longer valid. This object has been cancelled");
        }
        return this.req;
    }

    public HttpServletResponse getResponse(boolean enforceScope) {
        if (enforceScope && !this.isInScope) {
            throw new IllegalStateException("Response object no longer valid. This object has been cancelled");
        }
        return this.response;
    }

    @Override
    public HttpServletRequest getRequest() {
        return this.getRequest(true);
    }

    @Override
    public HttpServletResponse getResponse() {
        return this.getResponse(true);
    }

    @Override
    public Broadcaster getBroadcaster() {
        return this.getBroadcaster(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Broadcaster getBroadcaster(boolean autoCreate) {
        if (this.broadcaster == null) {
            throw new IllegalStateException("No Broadcaster associated with this AtmosphereResource.");
        }
        String s = this.config.getInitParameter(ApplicationConfig.RECOVER_DEAD_BROADCASTER);
        if (s != null) {
            autoCreate = Boolean.parseBoolean(s);
        }
        if (autoCreate && this.broadcaster.isDestroyed() && BroadcasterFactory.getDefault() != null) {
            logger.debug("Broadcaster {} has been destroyed and cannot be re-used. Recreating a new one with the same name. You can turn off that mechanism by adding, in web.xml, {} set to false", (Object)this.broadcaster.getID(), (Object)ApplicationConfig.RECOVER_DEAD_BROADCASTER);
            Broadcaster.SCOPE scope = this.broadcaster.getScope();
            AtmosphereResourceImpl atmosphereResourceImpl = this;
            synchronized (atmosphereResourceImpl) {
                String id = scope != Broadcaster.SCOPE.REQUEST ? this.broadcaster.getID() : this.broadcaster.getID() + ".recovered" + UUID.randomUUID();
                this.broadcaster = BroadcasterFactory.getDefault().lookup(id, true);
                this.broadcaster.setScope(scope);
                this.broadcaster.addAtmosphereResource(this);
            }
        }
        return this.broadcaster;
    }

    @Override
    public void setBroadcaster(Broadcaster broadcaster) {
        this.broadcaster = broadcaster;
    }

    @Override
    public AtmosphereServlet.AtmosphereConfig getAtmosphereConfig() {
        return this.config;
    }

    public AtmosphereServlet.Action action() {
        return this.action;
    }

    public void setIsInScope(boolean isInScope) {
        this.isInScope = isInScope;
    }

    public boolean isInScope() {
        return this.isInScope;
    }

    @Override
    public void setSerializer(Serializer s) {
        this.serializer = s;
    }

    protected boolean isResumed() {
        return this.isResumed;
    }

    protected boolean isCancelled() {
        return this.isCancelled;
    }

    @Override
    public void write(OutputStream os, Object o) throws IOException {
        if (o == null) {
            throw new IllegalStateException("Object cannot be null");
        }
        if (this.serializer != null) {
            this.serializer.write(os, o);
        } else {
            this.response.getOutputStream().write(o.toString().getBytes());
        }
    }

    @Override
    public Serializer getSerializer() {
        return this.serializer;
    }

    public static String createStreamingPadding(String padding) {
        StringBuilder s = new StringBuilder();
        if (padding == null || padding.equalsIgnoreCase("atmosphere")) {
            s.append("<!-- ---------------------------------------------------------------- http://github.com/Atmosphere ------------------------------------------------------------------------ -->\n");
            s.append("<!-- Welcome to the Atmosphere Framework. To work with all the browsers when suspending connection, Atmosphere must output some data to makes WebKit based browser working.-->\n");
            for (int i = 0; i < 10; ++i) {
                s.append("<!-- --------------------------------------------------------------------------------------------------------------------------------------------------------------------- -->\n");
            }
            s.append("<!-- EOD -->");
        } else {
            for (int i = 0; i < 2048; ++i) {
                s.append(" ");
            }
        }
        return s.toString();
    }

    @Override
    public void addEventListener(AtmosphereResourceEventListener e) {
        if (this.listeners.contains(e)) {
            return;
        }
        this.listeners.add(e);
    }

    @Override
    public void removeEventListener(AtmosphereResourceEventListener e) {
        this.listeners.remove(e);
    }

    @Override
    public void removeEventListeners() {
        this.listeners.clear();
    }

    @Override
    public void notifyListeners() {
        this.notifyListeners(this.event);
    }

    @Override
    public void notifyListeners(AtmosphereResourceEvent event) {
        if (this.listeners.size() <= 0) {
            return;
        }
        logger.trace("Invoking listener with {}", (Object)event);
        AtmosphereServlet.Action oldAction = this.action;
        try {
            if (event.isResuming() || event.isResumedOnTimeout()) {
                this.onResume(event);
            } else if (event.isCancelled()) {
                this.onDisconnect(event);
            } else if (!this.isSuspendEvent.getAndSet(true) && event.isSuspended()) {
                this.onSuspend(event);
            } else if (event.throwable() != null) {
                this.onThrowable(event);
            } else {
                this.onBroadcast(event);
            }
            if (oldAction.type != this.action.type) {
                this.action().type = AtmosphereServlet.Action.TYPE.CREATED;
            }
        }
        catch (Throwable t) {
            logger.trace("Listener error {}", t);
            ((AtmosphereResourceEventImpl)AtmosphereResourceEventImpl.class.cast(event)).setThrowable(t);
            try {
                this.onThrowable(event);
            }
            catch (Throwable t2) {
                logger.warn("Listener error {}", t2);
            }
        }
    }

    public void onThrowable(Throwable t) {
        this.onThrowable(new AtmosphereResourceEventImpl(this, false, false, t));
    }

    void onThrowable(AtmosphereResourceEvent e) {
        AtmosphereHandler atmosphereHandler = (AtmosphereHandler)this.req.getAttribute(FrameworkConfig.ATMOSPHERE_HANDLER);
        for (AtmosphereResourceEventListener r : this.listeners) {
            r.onThrowable(e);
        }
    }

    void onSuspend(AtmosphereResourceEvent<HttpServletRequest, HttpServletResponse> e) {
        for (AtmosphereResourceEventListener r : this.listeners) {
            r.onSuspend(e);
        }
    }

    void onResume(AtmosphereResourceEvent<HttpServletRequest, HttpServletResponse> e) {
        for (AtmosphereResourceEventListener r : this.listeners) {
            r.onResume(e);
        }
    }

    void onDisconnect(AtmosphereResourceEvent<HttpServletRequest, HttpServletResponse> e) {
        for (AtmosphereResourceEventListener r : this.listeners) {
            r.onDisconnect(e);
        }
    }

    void onBroadcast(AtmosphereResourceEvent<HttpServletRequest, HttpServletResponse> e) {
        for (AtmosphereResourceEventListener r : this.listeners) {
            r.onBroadcast(e);
        }
    }

    public ConcurrentLinkedQueue<AtmosphereResourceEventListener> atmosphereResourceEventListener() {
        return this.listeners;
    }

    public synchronized void cancel() throws IOException {
        this.action.type = AtmosphereServlet.Action.TYPE.RESUME;
        this.isCancelled = true;
        this.cometSupport.action(this);
        if (AtmosphereResponse.class.isAssignableFrom(this.response.getClass())) {
            ((AtmosphereResponse)((Object)AtmosphereResponse.class.cast(this.response))).close();
            ((AtmosphereResponse)((Object)AtmosphereResponse.class.cast(this.response))).destroy();
        }
        if (AtmosphereRequest.class.isAssignableFrom(this.req.getClass())) {
            ((AtmosphereRequest)((Object)AtmosphereRequest.class.cast(this.req))).destroy();
        }
        if (this.broadcaster != null) {
            this.broadcaster.removeAtmosphereResource(this);
        }
        this.event.destroy();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AtmosphereResourceImpl that = (AtmosphereResourceImpl)o;
        if (this.enableAccessControl != that.enableAccessControl) {
            return false;
        }
        if (this.injectCacheHeaders != that.injectCacheHeaders) {
            return false;
        }
        if (this.isInScope != that.isInScope) {
            return false;
        }
        if (this.writeHeaders != that.writeHeaders) {
            return false;
        }
        if (this.atmosphereHandler != null ? !this.atmosphereHandler.equals(that.atmosphereHandler) : that.atmosphereHandler != null) {
            return false;
        }
        if (this.broadcaster != null ? !this.broadcaster.equals(that.broadcaster) : that.broadcaster != null) {
            return false;
        }
        if (this.isSuspendEvent != null ? !this.isSuspendEvent.equals(that.isSuspendEvent) : that.isSuspendEvent != null) {
            return false;
        }
        if (this.req != null ? !this.req.equals(that.req) : that.req != null) {
            return false;
        }
        return !(this.response != null ? !this.response.equals(that.response) : that.response != null);
    }

    public int hashCode() {
        int result = this.req != null ? this.req.hashCode() : 0;
        result = 31 * result + (this.response != null ? this.response.hashCode() : 0);
        result = 31 * result + (this.broadcaster != null ? this.broadcaster.hashCode() : 0);
        result = 31 * result + (this.isInScope ? 1 : 0);
        result = 31 * result + (this.injectCacheHeaders ? 1 : 0);
        result = 31 * result + (this.enableAccessControl ? 1 : 0);
        result = 31 * result + (this.isSuspendEvent != null ? this.isSuspendEvent.hashCode() : 0);
        result = 31 * result + (this.atmosphereHandler != null ? this.atmosphereHandler.hashCode() : 0);
        result = 31 * result + (this.writeHeaders ? 1 : 0);
        return result;
    }

    public String toString() {
        return "AtmosphereResourceImpl{, hasCode" + this.hashCode() + ",\n action=" + this.action + ",\n broadcaster=" + this.broadcaster.getClass().getName() + ",\n cometSupport=" + this.cometSupport + ",\n serializer=" + this.serializer + ",\n isInScope=" + this.isInScope + ",\n useWriter=" + this.useWriter + ",\n listeners=" + this.listeners + '}';
    }
}

