/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.websocket.protocol;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.atmosphere.cpr.AtmosphereRequest;
import org.atmosphere.cpr.AtmosphereResource;
import org.atmosphere.cpr.AtmosphereResponse;
import org.atmosphere.cpr.AtmosphereServlet;
import org.atmosphere.websocket.WebSocket;
import org.atmosphere.websocket.WebSocketProcessor;
import org.atmosphere.websocket.WebSocketProtocol;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EchoProtocol
implements WebSocketProtocol {
    private static final Logger logger = LoggerFactory.getLogger(EchoProtocol.class);
    private AtmosphereResource<HttpServletRequest, HttpServletResponse> resource;

    @Override
    public AtmosphereRequest onMessage(WebSocket webSocket, String data) {
        logger.trace("broadcast String");
        this.resource.getBroadcaster().broadcast(data);
        return null;
    }

    @Override
    public AtmosphereRequest onMessage(WebSocket webSocket, byte[] data, int offset, int length) {
        logger.trace("broadcast byte");
        byte[] b = new byte[length];
        System.arraycopy(data, offset, b, 0, length);
        this.resource.getBroadcaster().broadcast(b);
        return null;
    }

    @Override
    public void configure(AtmosphereServlet.AtmosphereConfig config) {
    }

    @Override
    public void onOpen(WebSocket webSocket) {
        this.resource = webSocket.resource();
    }

    @Override
    public void onClose(WebSocket webSocket) {
    }

    @Override
    public void onError(WebSocket webSocket, WebSocketProcessor.WebSocketException t) {
        logger.error(t.getMessage() + " Status {} Message {}", (Object)t.response().getStatus(), (Object)t.response().getStatusMessage());
    }

    @Override
    public boolean inspectResponse() {
        return false;
    }

    @Override
    public String handleResponse(AtmosphereResponse<?> res, String message) {
        return message;
    }

    @Override
    public byte[] handleResponse(AtmosphereResponse<?> res, byte[] message, int offset, int length) {
        return message;
    }
}

