/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.container;

import java.io.IOException;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.atmosphere.cpr.ApplicationConfig;
import org.atmosphere.cpr.AsynchronousProcessor;
import org.atmosphere.cpr.AtmosphereHandler;
import org.atmosphere.cpr.AtmosphereResourceImpl;
import org.atmosphere.cpr.AtmosphereServlet;
import org.atmosphere.cpr.FrameworkConfig;
import org.eclipse.jetty.continuation.Continuation;
import org.eclipse.jetty.continuation.ContinuationSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Jetty7CometSupport
extends AsynchronousProcessor {
    private static final Logger logger = LoggerFactory.getLogger(Jetty7CometSupport.class);
    protected final ConcurrentLinkedQueue<Continuation> resumed = new ConcurrentLinkedQueue();

    public Jetty7CometSupport(AtmosphereServlet.AtmosphereConfig config) {
        super(config);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AtmosphereServlet.Action service(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        AtmosphereServlet.Action action = null;
        Continuation c = ContinuationSupport.getContinuation((ServletRequest)req);
        if (c.isInitial()) {
            action = this.suspended(req, res);
            if (action.type == AtmosphereServlet.Action.TYPE.SUSPEND) {
                logger.debug("Suspending {}", (Object)res);
                if (action.timeout != -1L) {
                    c.setTimeout(action.timeout);
                } else {
                    c.setTimeout(Integer.MAX_VALUE);
                }
                c.suspend();
            } else if (action.type == AtmosphereServlet.Action.TYPE.RESUME) {
                Boolean resumeOnBroadcast = (Boolean)req.getAttribute("org.atmosphere.resumeOnBroadcast");
                if (resumeOnBroadcast != null && resumeOnBroadcast.booleanValue()) {
                    return action;
                }
                logger.debug("Resume {}", (Object)res);
                if (!this.resumed.remove(c)) {
                    try {
                        c.complete();
                    }
                    catch (IllegalStateException ex) {
                        logger.trace("Continuation.complete()", (Throwable)ex);
                    }
                    finally {
                        this.resumed(req, res);
                    }
                }
            }
        } else if (!c.isInitial() && c.isExpired()) {
            this.timedout(req, res);
        }
        return action;
    }

    @Override
    public AtmosphereServlet.Action resumed(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        logger.debug("(resumed) invoked:\n HttpServletRequest: {}\n HttpServletResponse: {}", (Object)request, (Object)response);
        AtmosphereResourceImpl r = (AtmosphereResourceImpl)request.getAttribute(FrameworkConfig.ATMOSPHERE_RESOURCE);
        AtmosphereHandler atmosphereHandler = (AtmosphereHandler)request.getAttribute(FrameworkConfig.ATMOSPHERE_HANDLER);
        atmosphereHandler.onStateChange(r.getAtmosphereResourceEvent());
        return new AtmosphereServlet.Action(AtmosphereServlet.Action.TYPE.RESUME);
    }

    @Override
    public void action(AtmosphereResourceImpl actionEvent) {
        super.action(actionEvent);
        if (actionEvent.isInScope() && actionEvent.action().type == AtmosphereServlet.Action.TYPE.RESUME && (this.config.getInitParameter(ApplicationConfig.RESUME_AND_KEEPALIVE) == null || this.config.getInitParameter(ApplicationConfig.RESUME_AND_KEEPALIVE).equalsIgnoreCase("false"))) {
            Continuation c = ContinuationSupport.getContinuation((ServletRequest)actionEvent.getRequest());
            if (c != null) {
                try {
                    c.complete();
                }
                catch (IllegalStateException ex) {
                    logger.trace("Continuation.complete() failed", (Throwable)ex);
                }
            }
        } else {
            try {
                actionEvent.getResponse().flushBuffer();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

