/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.cpr;

import java.io.IOException;
import java.io.Serializable;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.atmosphere.cpr.AtmosphereHandler;
import org.atmosphere.cpr.AtmosphereResource;
import org.atmosphere.cpr.AtmosphereResourceEventImpl;
import org.atmosphere.cpr.AtmosphereResourceImpl;
import org.atmosphere.cpr.AtmosphereServlet;
import org.atmosphere.websocket.WebSocketHttpServletResponse;
import org.atmosphere.websocket.WebSocketSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class WebSocketProcessor
implements Serializable {
    private static final Logger logger = LoggerFactory.getLogger(WebSocketProcessor.class);
    private final AtmosphereServlet atmosphereServlet;
    private final WebSocketSupport webSocketSupport;
    private final AtomicBoolean loggedMsg = new AtomicBoolean(false);
    private AtmosphereResource<HttpServletRequest, HttpServletResponse> resource;
    private AtmosphereHandler handler;

    public WebSocketProcessor(AtmosphereServlet atmosphereServlet, WebSocketSupport webSocketSupport) {
        this.webSocketSupport = webSocketSupport;
        this.atmosphereServlet = atmosphereServlet;
    }

    public final void connect(HttpServletRequest request) throws IOException {
        if (!this.loggedMsg.getAndSet(true)) {
            logger.info("Atmosphere detected WebSocketSupport: {}", (Object)this.webSocketSupport.getClass().getName());
        }
        WebSocketHttpServletResponse<WebSocketSupport> wsr = new WebSocketHttpServletResponse<WebSocketSupport>(this.webSocketSupport);
        request.setAttribute(WebSocketSupport.WEBSOCKET_SUSPEND, (Object)true);
        try {
            this.atmosphereServlet.doCometSupport(request, (HttpServletResponse)wsr);
        }
        catch (IOException e) {
            logger.info("failed invoking atmosphere servlet doCometSupport()", (Throwable)e);
        }
        catch (ServletException e) {
            logger.info("failed invoking atmosphere servlet doCometSupport()", (Throwable)e);
        }
        this.resource = (AtmosphereResource)request.getAttribute(AtmosphereServlet.ATMOSPHERE_RESOURCE);
        this.handler = (AtmosphereHandler)request.getAttribute(AtmosphereServlet.ATMOSPHERE_HANDLER);
        if (this.resource == null || !this.resource.getAtmosphereResourceEvent().isSuspended()) {
            logger.error("No AtmosphereResource has been suspended. The WebSocket will be closed.");
            this.webSocketSupport.close();
        }
    }

    public AtmosphereResource resource() {
        return this.resource;
    }

    public AtmosphereServlet atmosphereServlet() {
        return this.atmosphereServlet;
    }

    public HttpServletRequest request() {
        return this.resource.getRequest();
    }

    public WebSocketSupport webSocketSupport() {
        return this.webSocketSupport;
    }

    public abstract void broadcast(String var1);

    public abstract void broadcast(byte[] var1, int var2, int var3);

    public void close() {
        try {
            if (this.handler != null && this.resource != null) {
                this.handler.onStateChange(new AtmosphereResourceEventImpl((AtmosphereResourceImpl)this.resource, false, true));
            }
        }
        catch (IOException e) {
            if (AtmosphereResourceImpl.class.isAssignableFrom(this.resource.getClass())) {
                ((AtmosphereResourceImpl)AtmosphereResourceImpl.class.cast(this.resource)).onThrowable(e);
            }
            logger.info("Failed invoking atmosphere handler onStateChange()", (Throwable)e);
        }
    }

    public String toString() {
        return "WebSocketProcessor{ handler=" + this.handler + ", resource=" + this.resource + ", webSocketSupport=" + this.webSocketSupport + " }";
    }
}

