/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.util.gae;

import java.util.Set;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.atmosphere.cpr.AtmosphereResource;
import org.atmosphere.cpr.AtmosphereServlet;
import org.atmosphere.cpr.BroadcasterFuture;
import org.atmosphere.cpr.DefaultBroadcaster;
import org.atmosphere.util.gae.GAEBroadcasterConfig;

public class GAEDefaultBroadcaster
extends DefaultBroadcaster {
    public GAEDefaultBroadcaster() {
        this.bc = new GAEBroadcasterConfig(AtmosphereServlet.broadcasterFilters);
    }

    public GAEDefaultBroadcaster(String name) {
        super(name);
        this.bc = new GAEBroadcasterConfig(AtmosphereServlet.broadcasterFilters);
    }

    @Override
    public <T> Future<T> broadcast(T msg) {
        Object newMsg = this.filter(msg);
        if (msg == null) {
            return null;
        }
        BroadcasterFuture<Object> f = new BroadcasterFuture<Object>(newMsg);
        f.done();
        this.push((DefaultBroadcaster)this.new DefaultBroadcaster.Entry(newMsg, null, f, msg));
        return f;
    }

    @Override
    public <T> Future<T> broadcast(T msg, AtmosphereResource<?, ?> r) {
        Object newMsg = this.filter(msg);
        if (newMsg == null) {
            return null;
        }
        BroadcasterFuture<Object> f = new BroadcasterFuture<Object>(newMsg);
        f.done();
        this.push((DefaultBroadcaster)this.new DefaultBroadcaster.Entry(newMsg, r, f, msg));
        return f;
    }

    @Override
    public <T> Future<T> broadcast(T msg, Set<AtmosphereResource<?, ?>> subset) {
        Object newMsg = this.filter(msg);
        if (newMsg == null) {
            return null;
        }
        BroadcasterFuture<Object> f = new BroadcasterFuture<Object>(newMsg);
        f.done();
        this.push((DefaultBroadcaster)this.new DefaultBroadcaster.Entry(newMsg, subset, f, msg));
        return f;
    }

    @Override
    public <T> Future<T> delayBroadcast(T o, long delay, TimeUnit t) {
        throw new UnsupportedOperationException("ExecutorService not supported with Google App Engine");
    }

    @Override
    public Future<?> scheduleFixedBroadcast(Object o, long period, TimeUnit t) {
        throw new UnsupportedOperationException("ExecutorService not supported with Google App Engine");
    }
}

