/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.websocket;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.atmosphere.cpr.AtmosphereResource;
import org.atmosphere.handler.AbstractReflectorAtmosphereHandler;
import org.atmosphere.websocket.WebSocketHttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebSocketAtmosphereHandler
extends AbstractReflectorAtmosphereHandler {
    private static final Logger logger = LoggerFactory.getLogger(WebSocketAtmosphereHandler.class);

    @Override
    public void onRequest(AtmosphereResource<HttpServletRequest, HttpServletResponse> r) throws IOException {
        if (!r.getResponse().getClass().isAssignableFrom(WebSocketHttpServletResponse.class)) {
            try {
                r.getAtmosphereConfig().getServletContext().getNamedDispatcher(r.getAtmosphereConfig().getDispatcherName()).forward((ServletRequest)r.getRequest(), (ServletResponse)r.getResponse());
            }
            catch (ServletException e) {
                IOException ie = new IOException();
                ie.initCause(e);
                throw ie;
            }
        } else {
            this.upgrade(r);
        }
    }

    public void upgrade(AtmosphereResource<HttpServletRequest, HttpServletResponse> resource) throws IOException {
        logger.debug("Suspending request: {}", (Object)resource.getRequest());
        resource.suspend(-1L, false);
    }

    @Override
    public void destroy() {
    }
}

