/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.cpr;

import java.util.concurrent.TimeUnit;

public class BroadcasterLifeCyclePolicy {
    private final ATMOSPHERE_RESOURCE_POLICY policy;
    private final int time;
    private final TimeUnit timeUnit;

    private BroadcasterLifeCyclePolicy(ATMOSPHERE_RESOURCE_POLICY policy, int time, TimeUnit timeUnit) {
        this.policy = policy;
        this.time = time;
        this.timeUnit = timeUnit;
    }

    private BroadcasterLifeCyclePolicy(ATMOSPHERE_RESOURCE_POLICY policy) {
        this.policy = policy;
        this.time = -1;
        this.timeUnit = null;
    }

    public ATMOSPHERE_RESOURCE_POLICY getLifeCyclePolicy() {
        return this.policy;
    }

    public TimeUnit getTimeUnit() {
        return this.timeUnit;
    }

    public int getTimeout() {
        return this.time;
    }

    public static final class Builder {
        private ATMOSPHERE_RESOURCE_POLICY policy;
        private int time;
        private TimeUnit timeUnit;

        public Builder policy(ATMOSPHERE_RESOURCE_POLICY policy) {
            this.policy = policy;
            return this;
        }

        public Builder idleTimeInMS(int time) {
            this.timeUnit = TimeUnit.MILLISECONDS;
            return this;
        }

        public Builder idleTime(int time, TimeUnit timeUnit) {
            this.timeUnit = timeUnit;
            return this;
        }

        public BroadcasterLifeCyclePolicy build() {
            return new BroadcasterLifeCyclePolicy(this.policy, this.time, this.timeUnit);
        }
    }

    public static enum ATMOSPHERE_RESOURCE_POLICY {
        IDLE,
        IDLE_DESTROY,
        EMPTY,
        EMPTY_DESTROY,
        NEVER;

    }
}

