/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.util;

import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import org.atmosphere.cpr.AtmosphereResource;
import org.atmosphere.cpr.BroadcasterConfig;
import org.atmosphere.cpr.BroadcasterFuture;
import org.atmosphere.cpr.DefaultBroadcaster;

public class SimpleBroadcaster
extends DefaultBroadcaster {
    private static final ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1);

    public SimpleBroadcaster() {
        this.setID(SimpleBroadcaster.class.getSimpleName());
    }

    public SimpleBroadcaster(String id) {
        super(id);
    }

    @Override
    public void setBroadcasterConfig(BroadcasterConfig bc) {
        this.bc = bc;
        bc.setScheduledExecutorService(scheduler);
        bc.setExecutorService(null);
    }

    @Override
    public <T> Future<T> broadcast(T msg) {
        Object newMsg = this.filter(msg);
        if (newMsg == null) {
            return null;
        }
        BroadcasterFuture<Object> f = new BroadcasterFuture<Object>(newMsg);
        f.done();
        this.push((DefaultBroadcaster)this.new DefaultBroadcaster.Entry(newMsg, null, f, msg));
        return f;
    }

    @Override
    public <T> Future<T> broadcast(T msg, AtmosphereResource<?, ?> r) {
        Object newMsg = this.filter(msg);
        if (newMsg == null) {
            return null;
        }
        BroadcasterFuture<Object> f = new BroadcasterFuture<Object>(newMsg);
        f.done();
        this.push((DefaultBroadcaster)this.new DefaultBroadcaster.Entry(newMsg, r, f, msg));
        return f;
    }

    @Override
    public <T> Future<T> broadcast(T msg, Set<AtmosphereResource<?, ?>> subset) {
        Object newMsg = this.filter(msg);
        if (newMsg == null) {
            return null;
        }
        BroadcasterFuture<Object> f = new BroadcasterFuture<Object>(newMsg);
        f.done();
        this.push((DefaultBroadcaster)this.new DefaultBroadcaster.Entry(newMsg, subset, f, msg));
        return f;
    }
}

