/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.util;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Date;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

public class LoggingFormatter
extends Formatter {
    private static Logger log = Logger.getLogger(LoggingFormatter.class.getName());
    private static String lineSeparator = "\n";

    @Override
    public String format(LogRecord record) {
        StringBuffer sb = new StringBuffer();
        sb.append("[").append(Thread.currentThread().getName()).append("] ");
        Date date = new Date(record.getMillis());
        sb.append(date.toString()).append(" ");
        sb.append("[").append(record.getLevel().getLocalizedName()).append("] ");
        if (record.getSourceClassName() != null) {
            sb.append(record.getSourceClassName());
        } else {
            sb.append(record.getLoggerName());
        }
        if (record.getSourceMethodName() != null) {
            sb.append(" ");
            sb.append(record.getSourceMethodName());
        }
        sb.append(":");
        sb.append(this.formatMessage(record)).append(lineSeparator);
        if (record.getThrown() != null) {
            try {
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                record.getThrown().printStackTrace(pw);
                pw.close();
                sb.append(sw.toString());
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        sb.append(lineSeparator);
        return sb.toString();
    }

    public static void main(String[] args) {
        log.info("Info Event");
        log.severe("Severe Event");
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                log.info("Info Event in Thread");
            }
        }, "Thread into main");
        t.start();
        log.log(Level.SEVERE, "exception", new Exception());
    }

    static {
        try {
            String separator = System.getProperty("line.separator");
            if (separator != null && separator.trim().length() > 0) {
                lineSeparator = separator;
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }
}

