/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.util;

import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import org.atmosphere.cpr.AtmosphereResource;
import org.atmosphere.cpr.BroadcasterConfig;
import org.atmosphere.cpr.BroadcasterFuture;
import org.atmosphere.cpr.DefaultBroadcaster;

public class SimpleBroadcaster
extends DefaultBroadcaster {
    private static final ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1);

    public SimpleBroadcaster() {
        this.setID(SimpleBroadcaster.class.getSimpleName());
    }

    public SimpleBroadcaster(String id) {
        super(id);
    }

    @Override
    public void setBroadcasterConfig(BroadcasterConfig bc) {
        this.bc = bc;
        bc.setScheduledExecutorService(scheduler);
        bc.setExecutorService(null);
    }

    public BroadcasterFuture<Object> broadcast(Object msg) {
        if ((msg = this.filter(msg)) == null) {
            return null;
        }
        BroadcasterFuture<Object> f = new BroadcasterFuture<Object>(msg);
        f.done();
        this.push(new DefaultBroadcaster.Entry(msg, null, f));
        return f;
    }

    public BroadcasterFuture<Object> broadcast(Object msg, AtmosphereResource<?, ?> r) {
        if ((msg = this.filter(msg)) == null) {
            return null;
        }
        BroadcasterFuture<Object> f = new BroadcasterFuture<Object>(msg);
        f.done();
        this.push(new DefaultBroadcaster.Entry(msg, r, f));
        return f;
    }

    public BroadcasterFuture<Object> broadcast(Object msg, Set<AtmosphereResource<?, ?>> subset) {
        if ((msg = this.filter(msg)) == null) {
            return null;
        }
        BroadcasterFuture<Object> f = new BroadcasterFuture<Object>(msg);
        f.done();
        this.push(new DefaultBroadcaster.Entry(msg, subset, f));
        return f;
    }
}

