/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.container;

import java.io.IOException;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.logging.Level;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.atmosphere.cpr.AsynchronousProcessor;
import org.atmosphere.cpr.AtmosphereResourceImpl;
import org.atmosphere.cpr.AtmosphereServlet;
import org.atmosphere.cpr.CometSupport;
import org.jboss.servlet.http.HttpEvent;

public class JBossWebCometSupport
extends AsynchronousProcessor
implements CometSupport<AtmosphereResourceImpl> {
    public static final String HTTP_EVENT = "HttpEvent";
    private static final IllegalStateException unableToDetectComet = new IllegalStateException(JBossWebCometSupport.unableToDetectComet());
    private final ConcurrentLinkedQueue<HttpEvent> resumed = new ConcurrentLinkedQueue();

    public JBossWebCometSupport(AtmosphereServlet.AtmosphereConfig config) {
        super(config);
    }

    @Override
    public AtmosphereServlet.Action service(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        AtmosphereServlet.Action action;
        block23: {
            HttpEvent event = (HttpEvent)req.getAttribute(HTTP_EVENT);
            if (event == null) {
                throw unableToDetectComet;
            }
            action = null;
            if (event.getType() == HttpEvent.EventType.BEGIN) {
                action = this.suspended(req, res);
                if (action.type == AtmosphereServlet.Action.TYPE.SUSPEND) {
                    if (this.logger.isLoggable(Level.FINE)) {
                        this.logger.fine("Suspending " + res);
                    }
                    try {
                        if (action.timeout != -1L) {
                            event.setTimeout((int)action.timeout);
                            break block23;
                        }
                        event.setTimeout(Integer.MAX_VALUE);
                    }
                    catch (UnsupportedOperationException ex) {}
                } else if (action.type == AtmosphereServlet.Action.TYPE.RESUME) {
                    if (this.logger.isLoggable(Level.FINE)) {
                        this.logger.fine("Resuming " + res);
                    }
                    event.close();
                } else {
                    event.close();
                }
            } else if (event.getType() != HttpEvent.EventType.READ) {
                if (event.getType() == HttpEvent.EventType.ERROR) {
                    event.close();
                } else if (event.getType() == HttpEvent.EventType.END) {
                    if (!this.resumed.remove(event)) {
                        if (this.logger.isLoggable(Level.FINE)) {
                            this.logger.fine("Client closed connection " + res);
                        }
                        action = this.cancelled(req, res);
                    } else if (this.logger.isLoggable(Level.FINE)) {
                        this.logger.fine("Cancelling " + res);
                    }
                    event.close();
                } else if (event.getType() == HttpEvent.EventType.TIMEOUT) {
                    if (this.logger.isLoggable(Level.FINE)) {
                        this.logger.fine("Timing out " + res);
                    }
                    action = this.timedout(req, res);
                    event.close();
                }
            }
        }
        return action;
    }

    @Override
    public AtmosphereServlet.Action cancelled(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        AtmosphereServlet.Action action = super.cancelled(req, res);
        if (req.getAttribute(MAX_INACTIVE) != null && (Long)Long.class.cast(req.getAttribute(MAX_INACTIVE)) == -1L) {
            HttpEvent event = (HttpEvent)req.getAttribute(HTTP_EVENT);
            if (event == null) {
                return action;
            }
            this.resumed.offer(event);
            event.close();
        }
        return action;
    }

    @Override
    public void action(AtmosphereResourceImpl actionEvent) {
        block4: {
            super.action(actionEvent);
            if (actionEvent.action().type == AtmosphereServlet.Action.TYPE.RESUME && actionEvent.isInScope()) {
                try {
                    HttpEvent event = (HttpEvent)actionEvent.getRequest().getAttribute(HTTP_EVENT);
                    this.resumed.offer(event);
                    if (this.config.getInitParameter(AtmosphereServlet.RESUME_AND_KEEPALIVE) == null || this.config.getInitParameter(AtmosphereServlet.RESUME_AND_KEEPALIVE).equalsIgnoreCase("false")) {
                        event.close();
                    }
                }
                catch (IOException ex) {
                    if (!this.logger.isLoggable(Level.FINE)) break block4;
                    this.logger.log(Level.FINE, "", ex);
                }
            }
        }
    }

    private static String unableToDetectComet() {
        StringBuilder sb = new StringBuilder();
        sb.append("JBoss failed to detect this is a Comet application because the APR Connector is not enabled. ");
        sb.append("\nMake sure atmosphere-compat-jboss.jar is not under your WEB-INF/lib and ");
        sb.append("\nthere is no context.xml under WEB-INF");
        return sb.toString();
    }
}

