/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.cpr;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class BroadcasterFuture<E>
implements Future {
    private final CountDownLatch latch;
    private boolean isCancelled = false;
    private boolean isDone = false;
    private final E msg;

    public BroadcasterFuture(E msg) {
        this.msg = msg;
        this.latch = new CountDownLatch(1);
    }

    @Override
    public boolean cancel(boolean b) {
        if (this.latch.getCount() == 1L) {
            this.latch.countDown();
            this.isCancelled = true;
        }
        return this.isCancelled;
    }

    @Override
    public boolean isCancelled() {
        return this.isCancelled;
    }

    @Override
    public boolean isDone() {
        this.isDone = true;
        return this.isDone;
    }

    public void done() {
        this.isDone = true;
        this.latch.countDown();
    }

    public E get() throws InterruptedException, ExecutionException {
        this.latch.await();
        return this.msg;
    }

    public E get(long l, TimeUnit tu) throws InterruptedException, ExecutionException, TimeoutException {
        this.latch.await(l, tu);
        return this.msg;
    }
}

