/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.cpr;

import java.io.IOException;
import java.io.Serializable;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.atmosphere.cpr.AtmosphereHandler;
import org.atmosphere.cpr.AtmosphereResource;
import org.atmosphere.cpr.AtmosphereResourceEventImpl;
import org.atmosphere.cpr.AtmosphereResourceImpl;
import org.atmosphere.cpr.AtmosphereServlet;
import org.atmosphere.websocket.WebSocketHttpServletResponse;
import org.atmosphere.websocket.WebSocketSupport;

public class WebSocketProcessor
implements Serializable {
    private final AtmosphereServlet atmosphereServlet;
    private AtomicBoolean loggedMsg = new AtomicBoolean(false);
    private AtmosphereResource r;
    private AtmosphereHandler ah;
    private final WebSocketSupport webSocketSupport;

    public WebSocketProcessor(AtmosphereServlet atmosphereServlet, WebSocketSupport webSocketSupport) {
        this.webSocketSupport = webSocketSupport;
        this.atmosphereServlet = atmosphereServlet;
    }

    public void connect(HttpServletRequest request) throws IOException {
        if (!this.loggedMsg.getAndSet(true)) {
            AtmosphereServlet.logger.info("Atmosphere detected WebSocketSupport: " + this.webSocketSupport.getClass().getName());
        }
        request.setAttribute(WebSocketSupport.WEBSOCKET_SUSPEND, (Object)"true");
        try {
            this.atmosphereServlet.doCometSupport(request, (HttpServletResponse)new WebSocketHttpServletResponse<WebSocketSupport>(this.webSocketSupport));
        }
        catch (IOException e) {
            AtmosphereServlet.logger.log(Level.INFO, "", e);
        }
        catch (ServletException e) {
            AtmosphereServlet.logger.log(Level.INFO, "", e);
        }
        this.r = (AtmosphereResource)request.getAttribute(AtmosphereServlet.ATMOSPHERE_RESOURCE);
        this.ah = (AtmosphereHandler)request.getAttribute(AtmosphereServlet.ATMOSPHERE_HANDLER);
        if (!this.r.getAtmosphereResourceEvent().isSuspended()) {
            this.webSocketSupport.close();
        }
    }

    public void broadcast(byte frame, String data) {
        this.r.getBroadcaster().broadcast(data);
    }

    public void broadcast(byte frame, byte[] data, int offset, int length) {
        this.r.getBroadcaster().broadcast(data);
    }

    public void close() {
        try {
            this.ah.onStateChange(new AtmosphereResourceEventImpl((AtmosphereResourceImpl)this.r, false, true));
        }
        catch (IOException e) {
            AtmosphereServlet.logger.log(Level.INFO, "", e);
        }
    }
}

