/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.cpr;

import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import org.atmosphere.cpr.BroadcastFilter;
import org.atmosphere.cpr.BroadcastFilterLifecycle;

public class BroadcasterConfig {
    static final int numOfProcessor = Runtime.getRuntime().availableProcessors();
    protected ConcurrentLinkedQueue<BroadcastFilter> filters = new ConcurrentLinkedQueue();
    private ExecutorService executorService;
    private ExecutorService defaultExecutorService;
    private ScheduledExecutorService scheduler;
    private final Object[] lock = new Object[0];

    public BroadcasterConfig() {
        this.configExecutors();
    }

    public BroadcasterConfig(ExecutorService executorService, ScheduledExecutorService scheduler) {
        this.executorService = executorService;
        this.scheduler = scheduler;
    }

    protected void configExecutors() {
        this.defaultExecutorService = this.executorService = Executors.newFixedThreadPool(numOfProcessor);
    }

    public void setExecutorService(ExecutorService executorService) {
        this.executorService = executorService;
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    public boolean addFilter(BroadcastFilter e) {
        if (this.filters.contains(e)) {
            return false;
        }
        if (e instanceof BroadcastFilterLifecycle) {
            ((BroadcastFilterLifecycle)e).init();
        }
        return this.filters.offer(e);
    }

    public void destroy() {
        if (this.executorService != null) {
            this.executorService.shutdown();
        }
        if (this.defaultExecutorService != null) {
            this.defaultExecutorService.shutdown();
        }
        if (this.scheduler != null) {
            this.scheduler.shutdown();
        }
        for (BroadcastFilter f : this.filters) {
            if (!(f instanceof BroadcastFilterLifecycle)) continue;
            ((BroadcastFilterLifecycle)f).destroy();
        }
    }

    public boolean removeFilter(BroadcastFilter e) {
        if (e instanceof BroadcastFilterLifecycle) {
            ((BroadcastFilterLifecycle)e).destroy();
        }
        return this.filters.remove(e);
    }

    protected BroadcastFilter.BroadcastAction filter(Object object) {
        BroadcastFilter.BroadcastAction transformed = new BroadcastFilter.BroadcastAction(object);
        for (BroadcastFilter mf : this.filters) {
            transformed = mf.filter(transformed.message());
            if (transformed != null && transformed.action() != BroadcastFilter.BroadcastAction.ACTION.ABORT) continue;
            return transformed;
        }
        return transformed;
    }

    public ExecutorService getDefaultExecutorService() {
        return this.defaultExecutorService;
    }

    public void setScheduledExecutorService(ScheduledExecutorService executorService) {
        this.executorService = executorService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ScheduledExecutorService getScheduledExecutorService() {
        Object[] objectArray = this.lock;
        synchronized (this.lock) {
            if (this.scheduler == null) {
                this.scheduler = Executors.newScheduledThreadPool(numOfProcessor);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.scheduler;
        }
    }
}

