/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.container;

import java.io.IOException;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.logging.Level;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.atmosphere.cpr.AsynchronousProcessor;
import org.atmosphere.cpr.AtmosphereResourceImpl;
import org.atmosphere.cpr.AtmosphereServlet;
import org.atmosphere.cpr.CometSupport;
import org.jboss.servlet.http.HttpEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JBossWebCometSupport
extends AsynchronousProcessor
implements CometSupport<AtmosphereResourceImpl> {
    public static final String HTTP_EVENT = "HttpEvent";
    private static final IllegalStateException unableToDetectComet = new IllegalStateException(JBossWebCometSupport.unableToDetectComet());
    private final ConcurrentLinkedQueue<HttpEvent> resumed = new ConcurrentLinkedQueue();

    public JBossWebCometSupport(AtmosphereServlet.AtmosphereConfig config) {
        super(config);
    }

    @Override
    public AtmosphereServlet.Action service(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        AtmosphereServlet.Action action;
        block23: {
            HttpEvent event = (HttpEvent)req.getAttribute(HTTP_EVENT);
            if (event == null) {
                throw unableToDetectComet;
            }
            action = null;
            if (event.getType() == HttpEvent.EventType.BEGIN) {
                action = this.suspended(req, res);
                if (action.type == AtmosphereServlet.Action.TYPE.SUSPEND) {
                    if (this.logger.isLoggable(Level.FINE)) {
                        this.logger.fine("Suspending " + res);
                    }
                    try {
                        if (action.timeout != -1L) {
                            event.setTimeout((int)action.timeout);
                            break block23;
                        }
                        event.setTimeout(Integer.MAX_VALUE);
                    }
                    catch (UnsupportedOperationException ex) {}
                } else if (action.type == AtmosphereServlet.Action.TYPE.RESUME) {
                    if (this.logger.isLoggable(Level.FINE)) {
                        this.logger.fine("Resuming " + res);
                    }
                    event.close();
                } else {
                    event.close();
                }
            } else if (event.getType() != HttpEvent.EventType.READ) {
                if (event.getType() == HttpEvent.EventType.ERROR) {
                    event.close();
                } else if (event.getType() == HttpEvent.EventType.END) {
                    if (!this.resumed.remove(event)) {
                        if (this.logger.isLoggable(Level.FINE)) {
                            this.logger.fine("Client closed connection " + res);
                        }
                        action = this.cancelled(req, res);
                    } else if (this.logger.isLoggable(Level.FINE)) {
                        this.logger.fine("Cancelling " + res);
                    }
                    event.close();
                } else if (event.getType() == HttpEvent.EventType.TIMEOUT) {
                    if (this.logger.isLoggable(Level.FINE)) {
                        this.logger.fine("Timing out " + res);
                    }
                    action = this.timedout(req, res);
                    event.close();
                }
            }
        }
        return action;
    }

    @Override
    public void action(AtmosphereResourceImpl actionEvent) {
        block3: {
            super.action(actionEvent);
            if (actionEvent.action().type == AtmosphereServlet.Action.TYPE.RESUME) {
                try {
                    HttpEvent event = (HttpEvent)actionEvent.getRequest().getAttribute(HTTP_EVENT);
                    this.resumed.offer(event);
                    event.close();
                }
                catch (IOException ex) {
                    if (!this.logger.isLoggable(Level.FINE)) break block3;
                    this.logger.log(Level.FINE, "", ex);
                }
            }
        }
    }

    private static String unableToDetectComet() {
        StringBuilder sb = new StringBuilder();
        sb.append("JBoss failed to detect this is a Comet application because context.xml ");
        sb.append("is missing.");
        sb.append("\nEnable it or if enabled add the following content under your WEB-INF/context.xml of your war file.");
        sb.append("\n<Context>");
        sb.append("\t<Loader delegate=\"true\"/>");
        sb.append("\t</Context>");
        return sb.toString();
    }
}

