/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.handler;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Enumeration;
import javax.servlet.Filter;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.atmosphere.cpr.AtmosphereResource;
import org.atmosphere.cpr.AtmosphereServletProcessor;
import org.atmosphere.handler.AbstractReflectorAtmosphereHandler;
import org.atmosphere.util.AtmosphereFilterChain;
import org.atmosphere.util.FilterConfigImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReflectorServletProcessor
extends AbstractReflectorAtmosphereHandler
implements AtmosphereServletProcessor {
    private String servletClass;
    private final ArrayList<String> filtersClass = new ArrayList();
    private FilterChainServletWrapper wrapper = new FilterChainServletWrapper();
    public static final String ATMOSPHERE_RESOURCE = AtmosphereResource.class.getName();
    public static final String ATMOSPHERE_HANDLER = ReflectorServletProcessor.class.getName();
    private final AtmosphereFilterChain filterChain = new AtmosphereFilterChain();

    void loadWebApplication(ServletConfig sc) throws MalformedURLException, InstantiationException, IllegalAccessException, ClassNotFoundException {
        URL url = sc.getServletContext().getResource("/WEB-INF/lib/");
        URLClassLoader urlC = new URLClassLoader(new URL[]{url}, Thread.currentThread().getContextClassLoader());
        if (this.getServletClass() != null) {
            Servlet servlet;
            try {
                servlet = (Servlet)urlC.loadClass(this.getServletClass()).newInstance();
            }
            catch (NullPointerException ex) {
                servlet = (Servlet)Thread.currentThread().getContextClassLoader().loadClass(this.servletClass).newInstance();
            }
            this.filterChain.setServlet(sc, servlet);
        }
        for (String filterName : this.filtersClass) {
            Filter f;
            try {
                f = (Filter)urlC.loadClass(filterName).newInstance();
            }
            catch (NullPointerException ex) {
                f = (Filter)Thread.currentThread().getContextClassLoader().loadClass(filterName).newInstance();
            }
            FilterConfigImpl fc = new FilterConfigImpl(sc);
            fc.setFilter(f);
            fc.setFilterName("/*");
            this.filterChain.addFilter(fc);
        }
    }

    @Override
    public void onRequest(AtmosphereResource<HttpServletRequest, HttpServletResponse> r) throws IOException {
        r.getRequest().setAttribute(ATMOSPHERE_RESOURCE, r);
        r.getRequest().setAttribute(ATMOSPHERE_HANDLER, (Object)this);
        try {
            this.wrapper.service((ServletRequest)r.getRequest(), (ServletResponse)r.getResponse());
        }
        catch (ServletException ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public void init(ServletConfig sc) throws ServletException {
        try {
            this.loadWebApplication(sc);
        }
        catch (Exception ex) {
            throw new ServletException((Throwable)ex);
        }
        this.wrapper.init(sc);
    }

    @Override
    public void destroy() {
        if (this.filterChain != null) {
            this.filterChain.destroy();
        }
    }

    public String getServletClass() {
        return this.servletClass;
    }

    public void setServletClass(String servletClass) {
        this.servletClass = servletClass;
    }

    public void setFilterClass(String filterClass) {
        if (filterClass == null) {
            return;
        }
        this.filtersClass.add(filterClass);
    }

    private class FilterChainServletWrapper
    extends HttpServlet {
        private FilterChainServletWrapper() {
        }

        public void destroy() {
            ReflectorServletProcessor.this.filterChain.destroy();
        }

        public String getInitParameter(String name) {
            return this.getServletConfig().getInitParameter(name);
        }

        public Enumeration getInitParameterNames() {
            return this.getServletConfig().getInitParameterNames();
        }

        public ServletConfig getServletConfig() {
            return ReflectorServletProcessor.this.filterChain.getServletConfig();
        }

        public ServletContext getServletContext() {
            return this.getServletConfig().getServletContext();
        }

        public String getServletInfo() {
            return ReflectorServletProcessor.this.filterChain.getServlet().getServletInfo();
        }

        public void init(ServletConfig sc) throws ServletException {
            ReflectorServletProcessor.this.filterChain.init();
        }

        public void init() throws ServletException {
        }

        public void log(String msg) {
            this.getServletContext().log(this.getServletName() + ": " + msg);
        }

        public void log(String message, Throwable t) {
            this.getServletContext().log(this.getServletName() + ": " + message, t);
        }

        public void service(ServletRequest req, ServletResponse res) throws ServletException, IOException {
            ReflectorServletProcessor.this.filterChain.invokeFilterChain(req, res);
        }

        public String getServletName() {
            return ReflectorServletProcessor.this.filterChain.getServletConfig().getServletName();
        }
    }
}

