/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.container;

import java.io.IOException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.atmosphere.cpr.AsynchronousProcessor;
import org.atmosphere.cpr.AtmosphereResourceImpl;
import org.atmosphere.cpr.AtmosphereServlet;
import org.atmosphere.cpr.CometSupport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BlockingIOCometSupport
extends AsynchronousProcessor
implements CometSupport<AtmosphereResourceImpl> {
    private static final String LATCH = "org.atmosphere.container.BlockingIOCometSupport.latch";

    public BlockingIOCometSupport(AtmosphereServlet.AtmosphereConfig config) {
        super(config);
    }

    @Override
    public AtmosphereServlet.Action service(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        AtmosphereServlet.Action action = this.suspended(req, res);
        if (action.type == AtmosphereServlet.Action.TYPE.SUSPEND) {
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.fine("Suspending" + res);
            }
            this.suspend(action, req, res);
        } else if (action.type == AtmosphereServlet.Action.TYPE.RESUME) {
            CountDownLatch latch;
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.fine("Resuming" + res);
            }
            if ((latch = (CountDownLatch)req.getSession().getAttribute(LATCH)) == null) {
                this.logger.fine("That response " + res + " wasn't suspended.");
                return action;
            }
            latch.countDown();
            AtmosphereServlet.Action nextAction = this.resumed(req, res);
            if (nextAction.type == AtmosphereServlet.Action.TYPE.SUSPEND && this.logger.isLoggable(Level.FINE)) {
                this.logger.fine("Suspending after Resuming" + res);
                this.suspend(action, req, res);
            }
        }
        return action;
    }

    private void suspend(AtmosphereServlet.Action action, HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        CountDownLatch latch = new CountDownLatch(1);
        req.setAttribute(LATCH, (Object)latch);
        if (this.supportSession()) {
            req.getSession().setAttribute(LATCH, (Object)latch);
        }
        try {
            if (action.timeout != -1L) {
                latch.await(action.timeout, TimeUnit.MILLISECONDS);
            } else {
                latch.await();
            }
        }
        catch (InterruptedException ex) {
            this.timedout(req, res);
        }
    }

    @Override
    public void action(AtmosphereResourceImpl actionEvent) {
        block6: {
            super.action(actionEvent);
            try {
                if (actionEvent.action().type == AtmosphereServlet.Action.TYPE.RESUME) {
                    CountDownLatch latch = (CountDownLatch)actionEvent.getRequest().getAttribute(LATCH);
                    if (latch == null && this.supportSession()) {
                        latch = (CountDownLatch)actionEvent.getRequest().getSession().getAttribute(LATCH);
                    } else {
                        actionEvent.getRequest().removeAttribute(LATCH);
                    }
                    if (latch != null) {
                        latch.countDown();
                    }
                }
            }
            catch (Exception ex) {
                if (!this.logger.isLoggable(Level.FINE)) break block6;
                this.logger.log(Level.FINE, "", ex);
            }
        }
    }
}

