/*
 *    Copyright (c) 2014-2024 AsyncHttpClient Project. All rights reserved.
 *
 *    Licensed under the Apache License, Version 2.0 (the "License");
 *    you may not use this file except in compliance with the License.
 *    You may obtain a copy of the License at
 *
 *        http://www.apache.org/licenses/LICENSE-2.0
 *
 *    Unless required by applicable law or agreed to in writing, software
 *    distributed under the License is distributed on an "AS IS" BASIS,
 *    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *    See the License for the specific language governing permissions and
 *    limitations under the License.
 */
package org.asynchttpclient.netty.request.body;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;

import java.util.List;

public class NettyCompositeByteArrayBody extends NettyDirectBody {

    private final byte[][] bytes;
    private final long contentLength;

    public NettyCompositeByteArrayBody(List<byte[]> bytes) {
        this.bytes = new byte[bytes.size()][];
        bytes.toArray(this.bytes);
        long l = 0;
        for (byte[] b : bytes) {
            l += b.length;
        }
        contentLength = l;
    }

    @Override
    public long getContentLength() {
        return contentLength;
    }

    @Override
    public ByteBuf byteBuf() {
        return Unpooled.wrappedBuffer(bytes);
    }
}
