/*
 * Decompiled with CFR 0.152.
 */
package org.asynchttpclient.netty.util;

import io.netty.buffer.ByteBuf;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.StandardCharsets;
import org.asynchttpclient.netty.util.ByteBufUtils;

public class Utf8ByteBufCharsetDecoder {
    private static final int INITIAL_CHAR_BUFFER_SIZE = 1024;
    private static final int UTF_8_MAX_BYTES_PER_CHAR = 4;
    private static final char INVALID_CHAR_REPLACEMENT = '\ufffd';
    private static final ThreadLocal<Utf8ByteBufCharsetDecoder> POOL = new ThreadLocal<Utf8ByteBufCharsetDecoder>(){

        @Override
        protected Utf8ByteBufCharsetDecoder initialValue() {
            return new Utf8ByteBufCharsetDecoder();
        }
    };
    private final CharsetDecoder decoder = Utf8ByteBufCharsetDecoder.configureReplaceCodingErrorActions(StandardCharsets.UTF_8.newDecoder());
    protected CharBuffer charBuffer = this.allocateCharBuffer(1024);
    private ByteBuffer splitCharBuffer = ByteBuffer.allocate(4);

    private static Utf8ByteBufCharsetDecoder pooledDecoder() {
        Utf8ByteBufCharsetDecoder decoder = POOL.get();
        decoder.reset();
        return decoder;
    }

    public static String decodeUtf8(ByteBuf buf) {
        return Utf8ByteBufCharsetDecoder.pooledDecoder().decode(buf);
    }

    public static String decodeUtf8(ByteBuf ... bufs) {
        return Utf8ByteBufCharsetDecoder.pooledDecoder().decode(bufs);
    }

    private static CharsetDecoder configureReplaceCodingErrorActions(CharsetDecoder decoder) {
        return decoder.onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE);
    }

    protected CharBuffer allocateCharBuffer(int l) {
        return CharBuffer.allocate(l);
    }

    private void ensureCapacity(int l) {
        if (this.charBuffer.position() == 0) {
            if (this.charBuffer.capacity() < l) {
                this.charBuffer = this.allocateCharBuffer(l);
            }
        } else if (this.charBuffer.remaining() < l) {
            CharBuffer newCharBuffer = this.allocateCharBuffer(this.charBuffer.position() + l);
            this.charBuffer.flip();
            newCharBuffer.put(this.charBuffer);
            this.charBuffer = newCharBuffer;
        }
    }

    public void reset() {
        Utf8ByteBufCharsetDecoder.configureReplaceCodingErrorActions(this.decoder.reset());
        this.charBuffer.clear();
        this.splitCharBuffer.clear();
    }

    private static int moreThanOneByteCharSize(byte firstByte) {
        if (firstByte >> 5 == -2 && (firstByte & 0x1E) != 0) {
            return 2;
        }
        if (firstByte >> 4 == -2) {
            return 3;
        }
        if (firstByte >> 3 == -2) {
            return 4;
        }
        return -1;
    }

    private static boolean isContinuation(byte b) {
        return b >> 6 == -2;
    }

    private boolean stashContinuationBytes(ByteBuffer nioBuffer, int missingBytes) {
        for (int i = 0; i < missingBytes; ++i) {
            byte b = nioBuffer.get();
            if (!Utf8ByteBufCharsetDecoder.isContinuation(b)) {
                nioBuffer.position(nioBuffer.position() - 1);
                this.charBuffer.append('\ufffd');
                this.splitCharBuffer.clear();
                return false;
            }
            this.splitCharBuffer.put(b);
        }
        return true;
    }

    private void handlePendingSplitCharBuffer(ByteBuffer nioBuffer, boolean endOfInput) {
        int charSize = Utf8ByteBufCharsetDecoder.moreThanOneByteCharSize(this.splitCharBuffer.get(0));
        if (charSize > 0) {
            int missingBytes = charSize - this.splitCharBuffer.position();
            if (nioBuffer.remaining() < missingBytes) {
                if (endOfInput) {
                    this.charBuffer.append('\ufffd');
                } else {
                    this.stashContinuationBytes(nioBuffer, nioBuffer.remaining());
                }
            } else if (this.stashContinuationBytes(nioBuffer, missingBytes)) {
                this.splitCharBuffer.flip();
                this.decoder.decode(this.splitCharBuffer, this.charBuffer, endOfInput && !nioBuffer.hasRemaining());
                this.splitCharBuffer.clear();
            }
        } else {
            this.charBuffer.append('\ufffd');
            this.splitCharBuffer.clear();
        }
    }

    protected void decodePartial(ByteBuffer nioBuffer, boolean endOfInput) {
        CoderResult res;
        if (this.splitCharBuffer.position() > 0 && nioBuffer.hasRemaining()) {
            this.handlePendingSplitCharBuffer(nioBuffer, endOfInput);
        }
        if (nioBuffer.hasRemaining() && (res = this.decoder.decode(nioBuffer, this.charBuffer, endOfInput)).isUnderflow() && nioBuffer.remaining() > 0) {
            this.splitCharBuffer.put(nioBuffer);
        }
    }

    private void decode(ByteBuffer[] nioBuffers, int length) {
        int count = nioBuffers.length;
        for (int i = 0; i < count; ++i) {
            this.decodePartial(nioBuffers[i].duplicate(), i == count - 1);
        }
    }

    private void decodeSingleNioBuffer(ByteBuffer nioBuffer, int length) {
        this.decoder.decode(nioBuffer, this.charBuffer, true);
    }

    public String decode(ByteBuf buf) {
        if (buf.isDirect()) {
            return buf.toString(StandardCharsets.UTF_8);
        }
        int length = buf.readableBytes();
        this.ensureCapacity(length);
        if (buf.nioBufferCount() == 1) {
            this.decodeSingleNioBuffer(buf.internalNioBuffer(buf.readerIndex(), length).duplicate(), length);
        } else {
            this.decode(buf.nioBuffers(), buf.readableBytes());
        }
        return this.charBuffer.flip().toString();
    }

    public String decode(ByteBuf ... bufs) {
        if (bufs.length == 1) {
            return this.decode(bufs[0]);
        }
        int totalSize = 0;
        int totalNioBuffers = 0;
        boolean withoutArray = false;
        for (ByteBuf buf : bufs) {
            if (!buf.hasArray()) {
                withoutArray = true;
                break;
            }
            totalSize += buf.readableBytes();
            totalNioBuffers += buf.nioBufferCount();
        }
        if (withoutArray) {
            return ByteBufUtils.byteBuf2StringDefault(StandardCharsets.UTF_8, bufs);
        }
        ByteBuffer[] nioBuffers = new ByteBuffer[totalNioBuffers];
        int i = 0;
        for (ByteBuf buf : bufs) {
            for (ByteBuffer nioBuffer : buf.nioBuffers()) {
                nioBuffers[i++] = nioBuffer;
            }
        }
        this.ensureCapacity(totalSize);
        this.decode(nioBuffers, totalSize);
        return this.charBuffer.flip().toString();
    }
}

