/*
 * Decompiled with CFR 0.152.
 */
package org.asynchttpclient.extras.rxjava2.maybe;

import io.netty.channel.Channel;
import io.netty.handler.codec.http.HttpHeaders;
import io.reactivex.MaybeEmitter;
import io.reactivex.exceptions.CompositeException;
import io.reactivex.exceptions.Exceptions;
import java.net.InetSocketAddress;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.net.ssl.SSLSession;
import org.asynchttpclient.AsyncHandler;
import org.asynchttpclient.HttpResponseBodyPart;
import org.asynchttpclient.HttpResponseStatus;
import org.asynchttpclient.extras.rxjava2.DisposedException;
import org.asynchttpclient.netty.request.NettyRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractMaybeAsyncHandlerBridge<T>
implements AsyncHandler<Void> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractMaybeAsyncHandlerBridge.class);
    private static volatile DisposedException sharedDisposed;
    protected final MaybeEmitter<T> emitter;
    private final AtomicBoolean delegateTerminated = new AtomicBoolean();

    protected AbstractMaybeAsyncHandlerBridge(MaybeEmitter<T> emitter) {
        this.emitter = Objects.requireNonNull(emitter);
    }

    public final AsyncHandler.State onBodyPartReceived(HttpResponseBodyPart content) throws Exception {
        return this.emitter.isDisposed() ? this.disposed() : this.delegate().onBodyPartReceived(content);
    }

    public final AsyncHandler.State onStatusReceived(HttpResponseStatus status) throws Exception {
        return this.emitter.isDisposed() ? this.disposed() : this.delegate().onStatusReceived(status);
    }

    public final AsyncHandler.State onHeadersReceived(HttpHeaders headers) throws Exception {
        return this.emitter.isDisposed() ? this.disposed() : this.delegate().onHeadersReceived(headers);
    }

    public AsyncHandler.State onTrailingHeadersReceived(HttpHeaders headers) throws Exception {
        return this.emitter.isDisposed() ? this.disposed() : this.delegate().onTrailingHeadersReceived(headers);
    }

    public final Void onCompleted() {
        Object result;
        if (this.delegateTerminated.getAndSet(true)) {
            return null;
        }
        try {
            result = this.delegate().onCompleted();
        }
        catch (Throwable t) {
            this.emitOnError(t);
            return null;
        }
        if (!this.emitter.isDisposed()) {
            if (result == null) {
                this.emitter.onComplete();
            } else {
                this.emitter.onSuccess(result);
            }
        }
        return null;
    }

    public final void onThrowable(Throwable t) {
        if (this.delegateTerminated.getAndSet(true)) {
            return;
        }
        Throwable error = t;
        try {
            this.delegate().onThrowable(t);
        }
        catch (Throwable x) {
            error = new CompositeException(Arrays.asList(t, x));
        }
        this.emitOnError(error);
    }

    public void onHostnameResolutionAttempt(String name) {
        this.executeUnlessEmitterDisposed(() -> this.delegate().onHostnameResolutionAttempt(name));
    }

    public void onHostnameResolutionSuccess(String name, List<InetSocketAddress> addresses) {
        this.executeUnlessEmitterDisposed(() -> this.delegate().onHostnameResolutionSuccess(name, addresses));
    }

    public void onHostnameResolutionFailure(String name, Throwable cause) {
        this.executeUnlessEmitterDisposed(() -> this.delegate().onHostnameResolutionFailure(name, cause));
    }

    public void onTcpConnectAttempt(InetSocketAddress remoteAddress) {
        this.executeUnlessEmitterDisposed(() -> this.delegate().onTcpConnectAttempt(remoteAddress));
    }

    public void onTcpConnectSuccess(InetSocketAddress remoteAddress, Channel connection) {
        this.executeUnlessEmitterDisposed(() -> this.delegate().onTcpConnectSuccess(remoteAddress, connection));
    }

    public void onTcpConnectFailure(InetSocketAddress remoteAddress, Throwable cause) {
        this.executeUnlessEmitterDisposed(() -> this.delegate().onTcpConnectFailure(remoteAddress, cause));
    }

    public void onTlsHandshakeAttempt() {
        this.executeUnlessEmitterDisposed(() -> this.delegate().onTlsHandshakeAttempt());
    }

    public void onTlsHandshakeSuccess(SSLSession sslSession) {
        this.executeUnlessEmitterDisposed(() -> this.delegate().onTlsHandshakeSuccess(sslSession));
    }

    public void onTlsHandshakeFailure(Throwable cause) {
        this.executeUnlessEmitterDisposed(() -> this.delegate().onTlsHandshakeFailure(cause));
    }

    public void onConnectionPoolAttempt() {
        this.executeUnlessEmitterDisposed(() -> this.delegate().onConnectionPoolAttempt());
    }

    public void onConnectionPooled(Channel connection) {
        this.executeUnlessEmitterDisposed(() -> this.delegate().onConnectionPooled(connection));
    }

    public void onConnectionOffer(Channel connection) {
        this.executeUnlessEmitterDisposed(() -> this.delegate().onConnectionOffer(connection));
    }

    public void onRequestSend(NettyRequest request) {
        this.executeUnlessEmitterDisposed(() -> this.delegate().onRequestSend(request));
    }

    public void onRetry() {
        this.executeUnlessEmitterDisposed(() -> this.delegate().onRetry());
    }

    protected final AsyncHandler.State disposed() {
        if (!this.delegateTerminated.getAndSet(true)) {
            DisposedException disposed = sharedDisposed;
            if (disposed == null) {
                disposed = new DisposedException("Subscription has been disposed.");
                StackTraceElement[] stackTrace = disposed.getStackTrace();
                if (stackTrace.length > 0) {
                    disposed.setStackTrace(new StackTraceElement[]{stackTrace[0]});
                }
                sharedDisposed = disposed;
            }
            this.delegate().onThrowable((Throwable)disposed);
        }
        return AsyncHandler.State.ABORT;
    }

    protected abstract AsyncHandler<? extends T> delegate();

    private void emitOnError(Throwable error) {
        Exceptions.throwIfFatal((Throwable)error);
        if (!this.emitter.isDisposed()) {
            this.emitter.onError(error);
        } else {
            LOGGER.debug("Not propagating onError after disposal: {}", (Object)error.getMessage(), (Object)error);
        }
    }

    private void executeUnlessEmitterDisposed(Runnable runnable) {
        if (this.emitter.isDisposed()) {
            this.disposed();
        } else {
            runnable.run();
        }
    }
}

