/*
 * Decompiled with CFR 0.152.
 */
package org.asynchttpclient.extras.retrofit;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import lombok.NonNull;
import okhttp3.Call;
import okhttp3.Request;
import org.asynchttpclient.AsyncHttpClient;
import org.asynchttpclient.extras.retrofit.AsyncHttpClientCall;

public final class AsyncHttpClientCallFactory
implements Call.Factory {
    @NonNull
    private final Supplier<AsyncHttpClient> httpClientSupplier;
    private final List<Consumer<AsyncHttpClientCall.AsyncHttpClientCallBuilder>> callCustomizers;

    public Call newCall(Request request) {
        AsyncHttpClientCall.AsyncHttpClientCallBuilder callBuilder = AsyncHttpClientCall.builder().httpClientSupplier(this.httpClientSupplier).request(request);
        AsyncHttpClientCall.runConsumers(this.callCustomizers, callBuilder);
        return callBuilder.build();
    }

    AsyncHttpClient getHttpClient() {
        return this.httpClientSupplier.get();
    }

    AsyncHttpClientCallFactory(@NonNull Supplier<AsyncHttpClient> httpClientSupplier, List<Consumer<AsyncHttpClientCall.AsyncHttpClientCallBuilder>> callCustomizers) {
        if (httpClientSupplier == null) {
            throw new NullPointerException("httpClientSupplier is marked @NonNull but is null");
        }
        this.httpClientSupplier = httpClientSupplier;
        this.callCustomizers = callCustomizers;
    }

    public static AsyncHttpClientCallFactoryBuilder builder() {
        return new AsyncHttpClientCallFactoryBuilder();
    }

    public AsyncHttpClientCallFactoryBuilder toBuilder() {
        AsyncHttpClientCallFactoryBuilder builder = new AsyncHttpClientCallFactoryBuilder().httpClientSupplier(this.httpClientSupplier);
        if (this.callCustomizers != null) {
            builder.callCustomizers(this.callCustomizers);
        }
        return builder;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AsyncHttpClientCallFactory)) {
            return false;
        }
        AsyncHttpClientCallFactory other = (AsyncHttpClientCallFactory)o;
        Supplier<AsyncHttpClient> this$httpClientSupplier = this.httpClientSupplier;
        Supplier<AsyncHttpClient> other$httpClientSupplier = other.httpClientSupplier;
        if (this$httpClientSupplier == null ? other$httpClientSupplier != null : !this$httpClientSupplier.equals(other$httpClientSupplier)) {
            return false;
        }
        List<Consumer<AsyncHttpClientCall.AsyncHttpClientCallBuilder>> this$callCustomizers = this.getCallCustomizers();
        List<Consumer<AsyncHttpClientCall.AsyncHttpClientCallBuilder>> other$callCustomizers = other.getCallCustomizers();
        return !(this$callCustomizers == null ? other$callCustomizers != null : !((Object)this$callCustomizers).equals(other$callCustomizers));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Supplier<AsyncHttpClient> $httpClientSupplier = this.httpClientSupplier;
        result = result * 59 + ($httpClientSupplier == null ? 43 : $httpClientSupplier.hashCode());
        List<Consumer<AsyncHttpClientCall.AsyncHttpClientCallBuilder>> $callCustomizers = this.getCallCustomizers();
        result = result * 59 + ($callCustomizers == null ? 43 : ((Object)$callCustomizers).hashCode());
        return result;
    }

    public String toString() {
        return "AsyncHttpClientCallFactory(httpClientSupplier=" + this.httpClientSupplier + ", callCustomizers=" + this.getCallCustomizers() + ")";
    }

    List<Consumer<AsyncHttpClientCall.AsyncHttpClientCallBuilder>> getCallCustomizers() {
        return this.callCustomizers;
    }

    public static class AsyncHttpClientCallFactoryBuilder {
        private ArrayList<Consumer<AsyncHttpClientCall.AsyncHttpClientCallBuilder>> callCustomizers;
        private Supplier<AsyncHttpClient> httpClientSupplier;

        public AsyncHttpClientCallFactoryBuilder httpClient(@NonNull AsyncHttpClient httpClient) {
            if (httpClient == null) {
                throw new NullPointerException("httpClient is marked @NonNull but is null");
            }
            return this.httpClientSupplier(() -> httpClient);
        }

        AsyncHttpClientCallFactoryBuilder() {
        }

        public AsyncHttpClientCallFactoryBuilder httpClientSupplier(@NonNull Supplier<AsyncHttpClient> httpClientSupplier) {
            if (httpClientSupplier == null) {
                throw new NullPointerException("httpClientSupplier is marked @NonNull but is null");
            }
            this.httpClientSupplier = httpClientSupplier;
            return this;
        }

        public AsyncHttpClientCallFactoryBuilder callCustomizer(Consumer<AsyncHttpClientCall.AsyncHttpClientCallBuilder> callCustomizer) {
            if (this.callCustomizers == null) {
                this.callCustomizers = new ArrayList();
            }
            this.callCustomizers.add(callCustomizer);
            return this;
        }

        public AsyncHttpClientCallFactoryBuilder callCustomizers(Collection<? extends Consumer<AsyncHttpClientCall.AsyncHttpClientCallBuilder>> callCustomizers) {
            if (this.callCustomizers == null) {
                this.callCustomizers = new ArrayList();
            }
            this.callCustomizers.addAll(callCustomizers);
            return this;
        }

        public AsyncHttpClientCallFactoryBuilder clearCallCustomizers() {
            if (this.callCustomizers != null) {
                this.callCustomizers.clear();
            }
            return this;
        }

        public AsyncHttpClientCallFactory build() {
            List<Consumer<AsyncHttpClientCall.AsyncHttpClientCallBuilder>> callCustomizers;
            switch (this.callCustomizers == null ? 0 : this.callCustomizers.size()) {
                case 0: {
                    callCustomizers = Collections.emptyList();
                    break;
                }
                case 1: {
                    callCustomizers = Collections.singletonList(this.callCustomizers.get(0));
                    break;
                }
                default: {
                    callCustomizers = Collections.unmodifiableList(new ArrayList<Consumer<AsyncHttpClientCall.AsyncHttpClientCallBuilder>>(this.callCustomizers));
                }
            }
            return new AsyncHttpClientCallFactory(this.httpClientSupplier, callCustomizers);
        }

        public String toString() {
            return "AsyncHttpClientCallFactory.AsyncHttpClientCallFactoryBuilder(httpClientSupplier=" + this.httpClientSupplier + ", callCustomizers=" + this.callCustomizers + ")";
        }
    }
}

