/*
 * Decompiled with CFR 0.152.
 */
package org.asynchttpclient.extras.guava;

import com.google.common.util.concurrent.RateLimiter;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import org.asynchttpclient.AsyncHandler;
import org.asynchttpclient.filter.AsyncHandlerWrapper;
import org.asynchttpclient.filter.FilterContext;
import org.asynchttpclient.filter.FilterException;
import org.asynchttpclient.filter.RequestFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RateLimitedThrottleRequestFilter
implements RequestFilter {
    private static final Logger logger = LoggerFactory.getLogger(RateLimitedThrottleRequestFilter.class);
    private final Semaphore available;
    private final int maxWaitMs;
    private final RateLimiter rateLimiter;

    public RateLimitedThrottleRequestFilter(int maxConnections, double rateLimitPerSecond) {
        this(maxConnections, rateLimitPerSecond, Integer.MAX_VALUE);
    }

    public RateLimitedThrottleRequestFilter(int maxConnections, double rateLimitPerSecond, int maxWaitMs) {
        this.maxWaitMs = maxWaitMs;
        this.rateLimiter = RateLimiter.create((double)rateLimitPerSecond);
        this.available = new Semaphore(maxConnections, true);
    }

    public <T> FilterContext<T> filter(FilterContext<T> ctx) throws FilterException {
        try {
            if (logger.isDebugEnabled()) {
                logger.debug("Current Throttling Status {}", (Object)this.available.availablePermits());
            }
            long startOfWait = System.currentTimeMillis();
            this.attemptConcurrencyPermitAcquistion(ctx);
            this.attemptRateLimitedPermitAcquistion(ctx, startOfWait);
        }
        catch (InterruptedException e) {
            throw new FilterException(String.format("Interrupted Request %s with AsyncHandler %s", ctx.getRequest(), ctx.getAsyncHandler()));
        }
        return new FilterContext.FilterContextBuilder(ctx).asyncHandler((AsyncHandler)new AsyncHandlerWrapper(ctx.getAsyncHandler(), this.available)).build();
    }

    private <T> void attemptRateLimitedPermitAcquistion(FilterContext<T> ctx, long startOfWait) throws FilterException {
        long wait = this.getMillisRemainingInMaxWait(startOfWait);
        if (!this.rateLimiter.tryAcquire(wait, TimeUnit.MILLISECONDS)) {
            throw new FilterException(String.format("Wait for rate limit exceeded during processing Request %s with AsyncHandler %s", ctx.getRequest(), ctx.getAsyncHandler()));
        }
    }

    private <T> void attemptConcurrencyPermitAcquistion(FilterContext<T> ctx) throws InterruptedException, FilterException {
        if (!this.available.tryAcquire(this.maxWaitMs, TimeUnit.MILLISECONDS)) {
            throw new FilterException(String.format("No slot available for processing Request %s with AsyncHandler %s", ctx.getRequest(), ctx.getAsyncHandler()));
        }
    }

    private long getMillisRemainingInMaxWait(long startOfWait) {
        int MINUTE_IN_MILLIS = 60000;
        long durationLeft = (long)this.maxWaitMs - (System.currentTimeMillis() - startOfWait);
        long nonNegativeDuration = Math.max(durationLeft, 0L);
        if (Long.MAX_VALUE - nonNegativeDuration < (long)MINUTE_IN_MILLIS) {
            return nonNegativeDuration - (long)MINUTE_IN_MILLIS;
        }
        return nonNegativeDuration;
    }
}

