/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.assertions.generator.cli;

import com.google.common.collect.Sets;
import com.google.common.reflect.TypeToken;
import java.io.File;
import java.io.IOException;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.assertj.assertions.generator.BaseAssertionGenerator;
import org.assertj.assertions.generator.description.ClassDescription;
import org.assertj.assertions.generator.description.converter.ClassToClassDescriptionConverter;
import org.assertj.assertions.generator.util.ClassUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AssertionGeneratorLauncher {
    private static final Logger logger = LoggerFactory.getLogger(AssertionGeneratorLauncher.class);
    private static ClassToClassDescriptionConverter classDescriptionConverter = new ClassToClassDescriptionConverter();

    public static void main(String[] args) throws IOException {
        Options options = new Options();
        options.addOption("H", "hierarchical", false, "Generate a hierarchy of assertions that follows the hierarchy of classes to assert");
        options.addOption("h", "help", false, "Print this help message");
        DefaultParser parser = new DefaultParser();
        try {
            CommandLine line = parser.parse(options, args);
            if (line.hasOption('h')) {
                AssertionGeneratorLauncher.printHelp(options);
                return;
            }
            Set<TypeToken<?>> classes = ClassUtil.collectClasses(line.getArgs());
            if (line.hasOption('H')) {
                AssertionGeneratorLauncher.generateHierarchicalAssertions(classes);
            } else {
                AssertionGeneratorLauncher.generateFlatAssertions(classes);
            }
        }
        catch (ParseException e) {
            System.err.println("Error trying to parse command-line arguments: " + e.getMessage());
            AssertionGeneratorLauncher.printHelp(options);
        }
    }

    private static void printHelp(Options options) {
        HelpFormatter help = new HelpFormatter();
        String cmdLine = "java " + AssertionGeneratorLauncher.class.getCanonicalName() + " [--help] [--hierarchical] <classes/packages>";
        help.printHelp(cmdLine, "Generate AssertJ-style assertions for the specified classes", options, "The list of classes can either be package names (which includes all packages in the class) or fully-qualified class names.");
    }

    private static void generateHierarchicalAssertions(Set<TypeToken<?>> types) throws IOException {
        LinkedHashSet typeSet = Sets.newLinkedHashSet(types);
        logger.info("Generating hierarchical assertions for classes {}", types);
        BaseAssertionGenerator customAssertionGenerator = new BaseAssertionGenerator();
        for (TypeToken<?> type : types) {
            logger.info("Generating hierarchical assertions for class : {}", type);
            File[] customAssertionFiles = customAssertionGenerator.generateHierarchicalCustomAssertionFor(AssertionGeneratorLauncher.toClassDescription(type), typeSet);
            logger.info("Generated {} hierarchical assertions files -> {}, {}", new Object[]{type, customAssertionFiles[0].getAbsolutePath(), customAssertionFiles[1].getAbsolutePath()});
        }
    }

    private static void generateFlatAssertions(Set<TypeToken<?>> types) throws IOException {
        logger.info("Generating assertions for types {}", types);
        BaseAssertionGenerator customAssertionGenerator = new BaseAssertionGenerator();
        for (TypeToken<?> type : types) {
            logger.info("Generating assertions for class : {}", type);
            File customAssertionFile = customAssertionGenerator.generateCustomAssertionFor(AssertionGeneratorLauncher.toClassDescription(type));
            logger.info("Generated {} assertions file -> {}", type, (Object)customAssertionFile.getAbsolutePath());
        }
    }

    private static ClassDescription toClassDescription(TypeToken<?> type) {
        return classDescriptionConverter.convertToClassDescription(type);
    }
}

