/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.assertions.generator;

import com.google.common.collect.Sets;
import com.google.common.reflect.TypeToken;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.assertj.assertions.generator.AssertionGenerator;
import org.assertj.assertions.generator.AssertionsEntryPointGenerator;
import org.assertj.assertions.generator.AssertionsEntryPointType;
import org.assertj.assertions.generator.DefaultTemplateRegistryProducer;
import org.assertj.assertions.generator.Template;
import org.assertj.assertions.generator.TemplateRegistry;
import org.assertj.assertions.generator.description.ClassDescription;
import org.assertj.assertions.generator.description.DataDescription;
import org.assertj.assertions.generator.description.FieldDescription;
import org.assertj.assertions.generator.description.GetterDescription;
import org.assertj.assertions.generator.util.ClassUtil;

public class BaseAssertionGenerator
implements AssertionGenerator,
AssertionsEntryPointGenerator {
    static final String TEMPLATES_DIR = "templates" + File.separator;
    private static final String IMPORT_LINE = "import %s;%s";
    private static final String PREDICATE = "${predicate}";
    private static final String PREDICATE_NEG = "${neg_predicate}";
    private static final String PREDICATE_FOR_JAVADOC = "${predicate_for_javadoc}";
    private static final String NEGATIVE_PREDICATE_FOR_JAVADOC = "${negative_predicate_for_javadoc}";
    private static final String PREDICATE_FOR_FOR_ERROR_MESSAGE_PART1 = "${predicate_for_error_message_part1}";
    private static final String PREDICATE_FOR_FOR_ERROR_MESSAGE_PART2 = "${predicate_for_error_message_part2}";
    private static final String NEGATIVE_PREDICATE_FOR_FOR_ERROR_MESSAGE_PART1 = "${negative_predicate_for_error_message_part1}";
    private static final String NEGATIVE_PREDICATE_FOR_FOR_ERROR_MESSAGE_PART2 = "${negative_predicate_for_error_message_part2}";
    private static final String PROPERTY_WITH_UPPERCASE_FIRST_CHAR = "${Property}";
    private static final String PROPERTY_GETTER_CALL = "${getter}";
    private static final String PROPERTY_WITH_LOWERCASE_FIRST_CHAR = "${property}";
    private static final String PROPERTY_WITH_SAFE = "${property_safe}";
    private static final String PACKAGE = "${package}";
    private static final String PROPERTY_TYPE = "${propertyType}";
    private static final String PROPERTY_SIMPLE_TYPE = "${propertySimpleType}";
    private static final String PROPERTY_ASSERT_TYPE = "${propertyAssertType}";
    private static final String CLASS_TO_ASSERT = "${class_to_assert}";
    private static final String CUSTOM_ASSERTION_CLASS = "${custom_assertion_class}";
    private static final String ABSTRACT_SUPER_ASSERTION_CLASS = "${super_assertion_class}";
    private static final String SELF_TYPE = "${self_type}";
    private static final String MYSELF = "${myself}";
    private static final String ELEMENT_TYPE = "${elementType}";
    private static final String ELEMENT_ASSERT_TYPE = "${elementAssertType}";
    private static final String ALL_ASSERTIONS_ENTRY_POINTS = "${all_assertions_entry_points}";
    private static final String IMPORTS = "${imports}";
    private static final String THROWS = "${throws}";
    private static final String THROWS_JAVADOC = "${throws_javadoc}";
    private static final String LINE_SEPARATOR = "\n";
    private static final Comparator<String> ORDER_BY_INCREASING_LENGTH = Comparator.comparingInt(String::length);
    private static final Set<String> JAVA_KEYWORDS = Sets.newHashSet((Object[])new String[]{"abstract", "assert", "boolean", "break", "byte", "case", "catch", "char", "class", "const", "continue", "default", "do", "double", "else", "enum", "extends", "false", "final", "finally", "float", "for", "goto", "if", "implements", "import", "instanceof", "int", "interface", "long", "native", "new", "null", "package", "protected", "private", "public", "return", "short", "static", "strictfp", "super", "switch", "synchronized", "this", "throw", "throws", "transient", "true", "try", "void", "volatile", "while"});
    private static final Pattern CLASS_NAME_PATTERN = Pattern.compile("(?m)^public class[\\s]+(?<CLASSNAME>\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*)\\b");
    private static final Set<TypeToken<?>> EMPTY_HIERARCHY = new HashSet();
    private static final String NON_PUBLIC_FIELD_VALUE_EXTRACTION = "org.assertj.core.util.introspection.FieldSupport.EXTRACTION.fieldValue(\"%s\", %s.class, actual)";
    private static final String ABSTRACT_ASSERT_SELF_TYPE = "S";
    private File targetBaseDirectory = Paths.get(".", new String[0]).toFile();
    private TemplateRegistry templateRegistry;
    private boolean generateAssertionsForAllFields = false;
    private String generatedAssertionsPackage = null;

    public BaseAssertionGenerator() throws IOException {
        this(TEMPLATES_DIR);
    }

    public BaseAssertionGenerator(String templatesDirectory) throws IOException {
        this.templateRegistry = DefaultTemplateRegistryProducer.create(templatesDirectory);
    }

    public void setDirectoryWhereAssertionFilesAreGenerated(File targetBaseDirectory) {
        this.targetBaseDirectory = targetBaseDirectory;
    }

    public void setGenerateAssertionsForAllFields(boolean generateAssertionsForAllFields) {
        this.generateAssertionsForAllFields = generateAssertionsForAllFields;
    }

    public void setGeneratedAssertionsPackage(String generatedAssertionsPackage) {
        this.checkGivenPackageIsValid(generatedAssertionsPackage);
        this.generatedAssertionsPackage = generatedAssertionsPackage;
    }

    private void checkGivenPackageIsValid(String generatedAssertionsPackage) {
        Validate.isTrue((boolean)StringUtils.isNotBlank((CharSequence)generatedAssertionsPackage), (String)"The given package '%s' must not be blank", (Object[])new Object[]{generatedAssertionsPackage});
        Validate.isTrue((!StringUtils.containsWhitespace((CharSequence)generatedAssertionsPackage) ? 1 : 0) != 0, (String)"The given package '%s' must not contain blank character", (Object[])new Object[]{generatedAssertionsPackage});
    }

    @Override
    public File generateCustomAssertionFor(ClassDescription classDescription) throws IOException {
        String assertionFileContent = this.generateCustomAssertionContentFor(classDescription);
        String directoryWhereToCreateAssertFiles = this.getDirectoryWhereToCreateAssertFilesFor(classDescription);
        BaseAssertionGenerator.buildDirectory(directoryWhereToCreateAssertFiles);
        return this.createFile(assertionFileContent, classDescription.getAssertClassFilename(), directoryWhereToCreateAssertFiles);
    }

    private String getDirectoryWhereToCreateAssertFilesFor(ClassDescription classDescription) {
        return this.getDirectoryPathCorrespondingToPackage(this.determinePackageName(classDescription));
    }

    @Override
    public File[] generateHierarchicalCustomAssertionFor(ClassDescription classDescription, Set<TypeToken<?>> allClasses) throws IOException {
        String[] assertionFileContent = this.generateHierarchicalCustomAssertionContentFor(classDescription, allClasses);
        String directoryWhereToCreateAssertFiles = this.getDirectoryWhereToCreateAssertFilesFor(classDescription);
        BaseAssertionGenerator.buildDirectory(directoryWhereToCreateAssertFiles);
        File[] assertionClassFiles = new File[2];
        String concreteAssertClassFileName = classDescription.getAssertClassFilename();
        String abstractAssertClassFileName = classDescription.getAbstractAssertClassFilename();
        assertionClassFiles[0] = this.createFile(assertionFileContent[0], abstractAssertClassFileName, directoryWhereToCreateAssertFiles);
        assertionClassFiles[1] = this.createFile(assertionFileContent[1], concreteAssertClassFileName, directoryWhereToCreateAssertFiles);
        return assertionClassFiles;
    }

    @Override
    public String[] generateHierarchicalCustomAssertionContentFor(ClassDescription classDescription, Set<TypeToken<?>> classes) {
        String abstractAssertClassContent = this.templateRegistry.getTemplate(Template.Type.ABSTRACT_ASSERT_CLASS).getContent();
        StringBuilder abstractAssertClassContentBuilder = new StringBuilder(abstractAssertClassContent);
        this.generateAssertionsForDeclaredGettersOf(abstractAssertClassContentBuilder, classDescription);
        this.generateAssertionsForDeclaredFieldsOf(abstractAssertClassContentBuilder, classDescription);
        abstractAssertClassContentBuilder.append(LINE_SEPARATOR).append("}").append(LINE_SEPARATOR);
        String concreteAssertClassContent = this.templateRegistry.getTemplate(Template.Type.HIERARCHICAL_ASSERT_CLASS).getContent();
        String[] assertionClassesContent = new String[]{this.fillAbstractAssertClassTemplate(abstractAssertClassContentBuilder.toString(), classDescription, classes), this.fillConcreteAssertClassTemplate(concreteAssertClassContent, classDescription)};
        return assertionClassesContent;
    }

    private String switchToComparableAssertIfPossible(String content, ClassDescription classDescription) {
        return classDescription.implementsComparable() ? StringUtils.replace((String)content, (String)"AbstractObjectAssert", (String)"AbstractComparableAssert") : content;
    }

    private String fillAbstractAssertClassTemplate(String abstractAssertClassTemplate, ClassDescription classDescription, Set<TypeToken<?>> classes) {
        return this.fillAssertClassTemplate(abstractAssertClassTemplate, classDescription, classes, false);
    }

    private String fillAssertClassTemplate(String template, ClassDescription classDescription, Set<TypeToken<?>> classesHierarchy, boolean concrete) {
        String parentAssertClassName;
        TreeSet<String> classesToImport = new TreeSet<String>();
        classesToImport.add(classDescription.getFullyQualifiedOuterClassName());
        if (template.contains("Assertions.")) {
            classesToImport.add("org.assertj.core.api.Assertions");
        }
        if (template.contains("Objects.")) {
            int areEqualArraysObjects;
            int totalObjects = StringUtils.countMatches((CharSequence)template, (CharSequence)"Objects.");
            int areEqualObjects = StringUtils.countMatches((CharSequence)template, (CharSequence)"Objects.deepEquals");
            int totalDeprecated = areEqualObjects + (areEqualArraysObjects = StringUtils.countMatches((CharSequence)template, (CharSequence)"Objects.deepEqualsArrays"));
            if (totalDeprecated > 0) {
                classesToImport.add("java.util.Objects");
            }
            if (totalObjects > totalDeprecated) {
                classesToImport.add("org.assertj.core.util.Objects");
            }
        }
        if (template.contains("Iterables.")) {
            classesToImport.add("org.assertj.core.internal.Iterables");
        }
        String string = parentAssertClassName = classesHierarchy.contains(classDescription.getSuperType()) ? classDescription.getFullyQualifiedParentAssertClassName() : "org.assertj.core.api.AbstractObjectAssert";
        if (classesHierarchy.contains(classDescription.getSuperType())) {
            classesToImport.add(parentAssertClassName);
        }
        String customAssertionClass = concrete ? classDescription.getAssertClassName() : classDescription.getAbstractAssertClassName();
        String selfType = concrete ? customAssertionClass : ABSTRACT_ASSERT_SELF_TYPE;
        String myself = concrete ? "this" : "myself";
        template = StringUtils.replace((String)template, (String)PACKAGE, (String)this.determinePackageName(classDescription));
        template = StringUtils.replace((String)template, (String)CUSTOM_ASSERTION_CLASS, (String)customAssertionClass);
        if ((template = StringUtils.replace((String)template, (String)ABSTRACT_SUPER_ASSERTION_CLASS, (String)ClassUtil.getTypeNameWithoutDots(parentAssertClassName))).contains("AbstractObjectAssert")) {
            classesToImport.add("org.assertj.core.api.AbstractObjectAssert");
        }
        template = StringUtils.replace((String)template, (String)CLASS_TO_ASSERT, (String)classDescription.getClassNameWithOuterClass());
        template = StringUtils.replace((String)template, (String)SELF_TYPE, (String)selfType);
        template = StringUtils.replace((String)template, (String)MYSELF, (String)myself);
        String neededImports = BaseAssertionGenerator.listNeededImports(classesToImport, this.determinePackageName(classDescription));
        template = StringUtils.replace((String)template, (String)IMPORTS, (String)(neededImports.isEmpty() ? "" : LINE_SEPARATOR + neededImports));
        template = this.switchToComparableAssertIfPossible(template, classDescription);
        return template;
    }

    private String determinePackageName(ClassDescription classDescription) {
        return this.generatedAssertionsPackage == null ? classDescription.getPackageName() : this.generatedAssertionsPackage;
    }

    private String fillConcreteAssertClassTemplate(String template, ClassDescription classDescription) {
        return this.fillAssertClassTemplate(template, classDescription, EMPTY_HIERARCHY, true);
    }

    @Override
    public String generateCustomAssertionContentFor(ClassDescription classDescription) {
        String classTemplateContent = this.templateRegistry.getTemplate(Template.Type.ASSERT_CLASS).getContent();
        StringBuilder assertionFileContentBuilder = new StringBuilder(classTemplateContent);
        this.generateAssertionsForGettersOf(assertionFileContentBuilder, classDescription);
        this.generateAssertionsForFieldsOf(assertionFileContentBuilder, classDescription);
        assertionFileContentBuilder.append(LINE_SEPARATOR).append("}").append(LINE_SEPARATOR);
        return this.fillConcreteAssertClassTemplate(assertionFileContentBuilder.toString(), classDescription);
    }

    @Override
    public String generateAssertionsEntryPointClassContentFor(Set<ClassDescription> classDescriptionSet, AssertionsEntryPointType assertionsEntryPointType, String entryPointClassPackage) {
        if (BaseAssertionGenerator.noClassDescriptionsGiven(classDescriptionSet)) {
            return "";
        }
        Template assertionEntryPointMethodTemplate = this.chooseAssertionEntryPointMethodTemplate(assertionsEntryPointType);
        Template assertionsEntryPointClassTemplate = this.chooseAssertionEntryPointClassTemplate(assertionsEntryPointType);
        return this.generateAssertionsEntryPointClassContent(classDescriptionSet, assertionsEntryPointClassTemplate, assertionEntryPointMethodTemplate, entryPointClassPackage);
    }

    private Template chooseAssertionEntryPointMethodTemplate(AssertionsEntryPointType assertionsEntryPointType) {
        switch (assertionsEntryPointType) {
            case SOFT: 
            case JUNIT_SOFT: 
            case AUTO_CLOSEABLE_SOFT: {
                return this.templateRegistry.getTemplate(Template.Type.SOFT_ENTRY_POINT_METHOD_ASSERTION);
            }
            case BDD: {
                return this.templateRegistry.getTemplate(Template.Type.BDD_ENTRY_POINT_METHOD_ASSERTION);
            }
            case BDD_SOFT: 
            case JUNIT_BDD_SOFT: 
            case AUTO_CLOSEABLE_BDD_SOFT: {
                return this.templateRegistry.getTemplate(Template.Type.BDD_SOFT_ENTRY_POINT_METHOD_ASSERTION);
            }
        }
        return this.templateRegistry.getTemplate(Template.Type.ASSERTION_ENTRY_POINT);
    }

    private Template chooseAssertionEntryPointClassTemplate(AssertionsEntryPointType assertionsEntryPointType) {
        switch (assertionsEntryPointType) {
            case SOFT: {
                return this.templateRegistry.getTemplate(Template.Type.SOFT_ASSERTIONS_ENTRY_POINT_CLASS);
            }
            case JUNIT_SOFT: {
                return this.templateRegistry.getTemplate(Template.Type.JUNIT_SOFT_ASSERTIONS_ENTRY_POINT_CLASS);
            }
            case AUTO_CLOSEABLE_SOFT: {
                return this.templateRegistry.getTemplate(Template.Type.AUTO_CLOSEABLE_SOFT_ASSERTIONS_ENTRY_POINT_CLASS);
            }
            case BDD: {
                return this.templateRegistry.getTemplate(Template.Type.BDD_ASSERTIONS_ENTRY_POINT_CLASS);
            }
            case BDD_SOFT: {
                return this.templateRegistry.getTemplate(Template.Type.BDD_SOFT_ASSERTIONS_ENTRY_POINT_CLASS);
            }
            case JUNIT_BDD_SOFT: {
                return this.templateRegistry.getTemplate(Template.Type.JUNIT_BDD_SOFT_ASSERTIONS_ENTRY_POINT_CLASS);
            }
            case AUTO_CLOSEABLE_BDD_SOFT: {
                return this.templateRegistry.getTemplate(Template.Type.AUTO_CLOSEABLE_BDD_SOFT_ASSERTIONS_ENTRY_POINT_CLASS);
            }
        }
        return this.templateRegistry.getTemplate(Template.Type.ASSERTIONS_ENTRY_POINT_CLASS);
    }

    @Override
    public File generateAssertionsEntryPointClassFor(Set<ClassDescription> classDescriptionSet, AssertionsEntryPointType assertionsEntryPointType, String entryPointClassPackage) throws IOException {
        if (BaseAssertionGenerator.noClassDescriptionsGiven(classDescriptionSet)) {
            return null;
        }
        String assertionsEntryPointFileContent = this.generateAssertionsEntryPointClassContentFor(classDescriptionSet, assertionsEntryPointType, entryPointClassPackage);
        String fileName = this.determineFileName(assertionsEntryPointFileContent, assertionsEntryPointType);
        return this.createAssertionsFileFor(classDescriptionSet, assertionsEntryPointFileContent, fileName, entryPointClassPackage);
    }

    private String determineFileName(String assertionsEntryPointFileContent, AssertionsEntryPointType assertionsEntryPointType) {
        Matcher classNameMatcher = CLASS_NAME_PATTERN.matcher(assertionsEntryPointFileContent);
        if (classNameMatcher.find()) {
            return classNameMatcher.group("CLASSNAME") + ".java";
        }
        return assertionsEntryPointType.getFileName();
    }

    private String generateAssertionsEntryPointClassContent(Set<ClassDescription> classDescriptionSet, Template entryPointAssertionsClassTemplate, Template entryPointAssertionMethodTemplate, String entryPointClassPackage) {
        String entryPointAssertionsClassContent = entryPointAssertionsClassTemplate.getContent();
        String classPackage = StringUtils.isEmpty((CharSequence)entryPointClassPackage) ? this.determineBestEntryPointsAssertionsClassPackage(classDescriptionSet) : entryPointClassPackage;
        entryPointAssertionsClassContent = StringUtils.replace((String)entryPointAssertionsClassContent, (String)PACKAGE, (String)classPackage);
        String allEntryPointsAssertionContent = this.generateAssertionEntryPointMethodsFor(classDescriptionSet, entryPointAssertionMethodTemplate);
        entryPointAssertionsClassContent = StringUtils.replace((String)entryPointAssertionsClassContent, (String)ALL_ASSERTIONS_ENTRY_POINTS, (String)allEntryPointsAssertionContent);
        return entryPointAssertionsClassContent;
    }

    private File createAssertionsFileFor(Set<ClassDescription> classDescriptionSet, String fileContent, String fileName, String assertionsClassPackage) throws IOException {
        String classPackage = StringUtils.isEmpty((CharSequence)assertionsClassPackage) ? this.determineBestEntryPointsAssertionsClassPackage(classDescriptionSet) : assertionsClassPackage;
        String assertionsDirectory = this.getDirectoryPathCorrespondingToPackage(classPackage);
        BaseAssertionGenerator.buildDirectory(assertionsDirectory);
        return this.createFile(fileContent, fileName, assertionsDirectory);
    }

    private String generateAssertionEntryPointMethodsFor(Set<ClassDescription> classDescriptionSet, Template assertionEntryPointMethodTemplate) {
        TreeSet<ClassDescription> sortedClassDescriptionSet = new TreeSet<ClassDescription>(classDescriptionSet);
        StringBuilder allAssertThatsContentBuilder = new StringBuilder();
        String lineSeparator = System.lineSeparator();
        for (ClassDescription classDescription : sortedClassDescriptionSet) {
            String assertionEntryPointMethodContent = assertionEntryPointMethodTemplate.getContent();
            assertionEntryPointMethodContent = StringUtils.replace((String)assertionEntryPointMethodContent, (String)CUSTOM_ASSERTION_CLASS, (String)classDescription.getFullyQualifiedAssertClassName());
            assertionEntryPointMethodContent = StringUtils.replace((String)assertionEntryPointMethodContent, (String)CLASS_TO_ASSERT, (String)classDescription.getFullyQualifiedClassName());
            allAssertThatsContentBuilder.append(lineSeparator).append(assertionEntryPointMethodContent);
        }
        return allAssertThatsContentBuilder.toString();
    }

    private String determineBestEntryPointsAssertionsClassPackage(Set<ClassDescription> classDescriptionSet) {
        if (this.generatedAssertionsPackage != null) {
            return this.generatedAssertionsPackage;
        }
        TreeSet<String> packages = new TreeSet<String>(ORDER_BY_INCREASING_LENGTH);
        for (ClassDescription classDescription : classDescriptionSet) {
            packages.add(classDescription.getPackageName());
        }
        return (String)packages.first();
    }

    private String getDirectoryPathCorrespondingToPackage(String packageName) {
        return this.targetBaseDirectory + File.separator + packageName.replace('.', File.separatorChar);
    }

    private static String listNeededImports(Set<String> typesToImport, String classPackage) {
        StringBuilder imports = new StringBuilder();
        for (String type : typesToImport) {
            if (!BaseAssertionGenerator.isImportNeeded(type, classPackage)) continue;
            imports.append(String.format(IMPORT_LINE, type, LINE_SEPARATOR));
        }
        return imports.toString();
    }

    private static boolean isImportNeeded(String type, String classPackage) {
        if (Objects.equals(classPackage, ClassUtil.packageOf(type))) {
            return false;
        }
        try {
            Class<?> clazz = Class.forName(type);
            return !clazz.isPrimitive() && !ClassUtil.isJavaLangType(clazz);
        }
        catch (ClassNotFoundException e) {
            return true;
        }
    }

    protected void generateAssertionsForGettersOf(StringBuilder contentBuilder, ClassDescription classDescription) {
        this.generateAssertionsForGetters(contentBuilder, classDescription.getGettersDescriptions(), classDescription);
    }

    protected void generateAssertionsForDeclaredGettersOf(StringBuilder contentBuilder, ClassDescription classDescription) {
        this.generateAssertionsForGetters(contentBuilder, classDescription.getDeclaredGettersDescriptions(), classDescription);
    }

    protected void generateAssertionsForGetters(StringBuilder assertionsForGetters, Set<GetterDescription> getters, ClassDescription classDescription) {
        for (GetterDescription getter : getters) {
            String assertionContent = this.assertionContentForProperty(getter, classDescription);
            assertionsForGetters.append(assertionContent).append(LINE_SEPARATOR);
        }
    }

    protected void generateAssertionsForFieldsOf(StringBuilder contentBuilder, ClassDescription classDescription) {
        this.generateAssertionsForFields(contentBuilder, classDescription.getFieldsDescriptions(), classDescription);
    }

    protected void generateAssertionsForDeclaredFieldsOf(StringBuilder contentBuilder, ClassDescription classDescription) {
        this.generateAssertionsForFields(contentBuilder, classDescription.getDeclaredFieldsDescriptions(), classDescription);
    }

    protected void generateAssertionsForFields(StringBuilder assertionsForPublicFields, Set<FieldDescription> fields, ClassDescription classDescription) {
        for (FieldDescription field : fields) {
            String assertionContent;
            if (!this.generateAssertionsForAllFields && !field.isPublic() || (assertionContent = this.assertionContentForField(field, classDescription)).isEmpty()) continue;
            assertionsForPublicFields.append(assertionContent).append(LINE_SEPARATOR);
        }
    }

    private String assertionContentForField(FieldDescription field, ClassDescription classDescription) {
        if (classDescription.hasGetterForField(field)) {
            return "";
        }
        String fieldName = field.getName();
        String assertionContent = this.baseAssertionContentFor(field, classDescription);
        assertionContent = assertionContent.replace("${getter}()", PROPERTY_WITH_LOWERCASE_FIRST_CHAR);
        assertionContent = StringUtils.remove((String)assertionContent, (String)THROWS);
        assertionContent = StringUtils.remove((String)assertionContent, (String)THROWS_JAVADOC);
        if (!field.isPublic()) {
            assertionContent = assertionContent.replace("actual.${property}", String.format(NON_PUBLIC_FIELD_VALUE_EXTRACTION, PROPERTY_WITH_LOWERCASE_FIRST_CHAR, PROPERTY_TYPE));
        }
        if (field.isPredicate()) {
            assertionContent = this.fillAssertionContentForPredicateField(field, assertionContent);
        }
        assertionContent = StringUtils.replace((String)assertionContent, (String)PROPERTY_WITH_UPPERCASE_FIRST_CHAR, (String)StringUtils.capitalize((String)field.getName()));
        assertionContent = StringUtils.replace((String)assertionContent, (String)PROPERTY_SIMPLE_TYPE, (String)this.getTypeName(field));
        assertionContent = StringUtils.replace((String)assertionContent, (String)PROPERTY_ASSERT_TYPE, (String)field.getAssertTypeName(this.determinePackageName(classDescription)));
        assertionContent = StringUtils.replace((String)assertionContent, (String)PROPERTY_TYPE, (String)this.getTypeName(field));
        assertionContent = StringUtils.replace((String)assertionContent, (String)PROPERTY_WITH_LOWERCASE_FIRST_CHAR, (String)fieldName);
        assertionContent = StringUtils.replace((String)assertionContent, (String)PROPERTY_WITH_SAFE, (String)BaseAssertionGenerator.unclashName(fieldName));
        return assertionContent;
    }

    private String getTypeName(DataDescription fieldOrGetter) {
        if (this.generatedAssertionsPackage != null) {
            return fieldOrGetter.getFullyQualifiedTypeName();
        }
        return fieldOrGetter.getTypeName();
    }

    private String fillAssertionContentForPredicateField(FieldDescription field, String assertionContent) {
        assertionContent = field.isPublic() ? assertionContent.replace("actual.${predicate}()", "actual." + field.getOriginalMember().getName()) : assertionContent.replace("actual.${predicate}()", String.format(NON_PUBLIC_FIELD_VALUE_EXTRACTION, field.getOriginalMember().getName(), "Boolean"));
        assertionContent = assertionContent.replace(PREDICATE_FOR_JAVADOC, field.getPredicateForJavadoc());
        assertionContent = assertionContent.replace(NEGATIVE_PREDICATE_FOR_JAVADOC, field.getNegativePredicateForJavadoc());
        assertionContent = assertionContent.replace(PREDICATE_FOR_FOR_ERROR_MESSAGE_PART1, field.getPredicateForErrorMessagePart1());
        assertionContent = assertionContent.replace(PREDICATE_FOR_FOR_ERROR_MESSAGE_PART2, field.getPredicateForErrorMessagePart2());
        assertionContent = assertionContent.replace(NEGATIVE_PREDICATE_FOR_FOR_ERROR_MESSAGE_PART1, field.getNegativePredicateForErrorMessagePart1());
        assertionContent = assertionContent.replace(NEGATIVE_PREDICATE_FOR_FOR_ERROR_MESSAGE_PART2, field.getNegativePredicateForErrorMessagePart2());
        assertionContent = StringUtils.replace((String)assertionContent, (String)PREDICATE, (String)field.getPredicate());
        assertionContent = StringUtils.replace((String)assertionContent, (String)PREDICATE_NEG, (String)field.getNegativePredicate());
        return assertionContent;
    }

    private static String unclashName(String unsafe) {
        return JAVA_KEYWORDS.contains(unsafe) || "actual".equals(unsafe) ? "expected" + StringUtils.capitalize((String)unsafe) : unsafe;
    }

    private String assertionContentForProperty(GetterDescription getter, ClassDescription classDescription) {
        String assertionContent = this.baseAssertionContentFor(getter, classDescription);
        assertionContent = this.declareExceptions(getter, assertionContent);
        String propertyName = getter.getName();
        if (getter.isPredicate()) {
            assertionContent = assertionContent.replace(PREDICATE_FOR_JAVADOC, getter.getPredicateForJavadoc());
            assertionContent = assertionContent.replace(NEGATIVE_PREDICATE_FOR_JAVADOC, getter.getNegativePredicateForJavadoc());
            assertionContent = assertionContent.replace(PREDICATE_FOR_FOR_ERROR_MESSAGE_PART1, getter.getPredicateForErrorMessagePart1());
            assertionContent = assertionContent.replace(PREDICATE_FOR_FOR_ERROR_MESSAGE_PART2, getter.getPredicateForErrorMessagePart2());
            assertionContent = assertionContent.replace(NEGATIVE_PREDICATE_FOR_FOR_ERROR_MESSAGE_PART1, getter.getNegativePredicateForErrorMessagePart1());
            assertionContent = assertionContent.replace(NEGATIVE_PREDICATE_FOR_FOR_ERROR_MESSAGE_PART2, getter.getNegativePredicateForErrorMessagePart2());
            assertionContent = StringUtils.replace((String)assertionContent, (String)PREDICATE, (String)getter.getOriginalMember().getName());
            assertionContent = StringUtils.replace((String)assertionContent, (String)PREDICATE_NEG, (String)getter.getNegativePredicate());
        }
        assertionContent = StringUtils.replace((String)assertionContent, (String)PROPERTY_GETTER_CALL, (String)getter.getOriginalMember().getName());
        assertionContent = StringUtils.replace((String)assertionContent, (String)PROPERTY_WITH_UPPERCASE_FIRST_CHAR, (String)StringUtils.capitalize((String)propertyName));
        assertionContent = StringUtils.replace((String)assertionContent, (String)PROPERTY_SIMPLE_TYPE, (String)this.getTypeName(getter));
        assertionContent = StringUtils.replace((String)assertionContent, (String)PROPERTY_ASSERT_TYPE, (String)getter.getAssertTypeName(this.determinePackageName(classDescription)));
        assertionContent = StringUtils.replace((String)assertionContent, (String)PROPERTY_TYPE, (String)this.getTypeName(getter));
        assertionContent = StringUtils.replace((String)assertionContent, (String)PROPERTY_WITH_LOWERCASE_FIRST_CHAR, (String)propertyName);
        assertionContent = StringUtils.replace((String)assertionContent, (String)PROPERTY_WITH_SAFE, (String)BaseAssertionGenerator.unclashName(propertyName));
        return assertionContent;
    }

    private String baseAssertionContentFor(DataDescription fieldOrProperty, ClassDescription classDescription) {
        String assertionContent = this.templateRegistry.getTemplate(Template.Type.HAS).getContent();
        if (fieldOrProperty.isPredicate()) {
            Template.Type type = this.determinePredicateType(fieldOrProperty, classDescription);
            assertionContent = this.templateRegistry.getTemplate(type).getContent();
        } else if (fieldOrProperty.isIterableType()) {
            assertionContent = StringUtils.replace((String)this.templateRegistry.getTemplate(Template.Type.HAS_FOR_ITERABLE).getContent(), (String)ELEMENT_TYPE, (String)fieldOrProperty.getElementTypeName());
            assertionContent = StringUtils.replace((String)assertionContent, (String)ELEMENT_ASSERT_TYPE, (String)fieldOrProperty.getElementAssertTypeName());
        } else if (fieldOrProperty.isArrayType()) {
            assertionContent = StringUtils.replace((String)this.templateRegistry.getTemplate(Template.Type.HAS_FOR_ARRAY).getContent(), (String)ELEMENT_TYPE, (String)fieldOrProperty.getElementTypeName());
            assertionContent = StringUtils.replace((String)assertionContent, (String)ELEMENT_ASSERT_TYPE, (String)fieldOrProperty.getElementAssertTypeName());
        } else if (fieldOrProperty.isRealNumberType()) {
            Template.Type type = fieldOrProperty.isPrimitiveWrapperType() ? Template.Type.HAS_FOR_REAL_NUMBER_WRAPPER : Template.Type.HAS_FOR_REAL_NUMBER;
            assertionContent = this.templateRegistry.getTemplate(type).getContent();
        } else if (fieldOrProperty.isWholeNumberType()) {
            Template.Type type = fieldOrProperty.isPrimitiveWrapperType() ? Template.Type.HAS_FOR_WHOLE_NUMBER_WRAPPER : Template.Type.HAS_FOR_WHOLE_NUMBER;
            assertionContent = this.templateRegistry.getTemplate(type).getContent();
        } else if (fieldOrProperty.isCharType()) {
            Template.Type type = fieldOrProperty.isPrimitiveWrapperType() ? Template.Type.HAS_FOR_CHARACTER : Template.Type.HAS_FOR_CHAR;
            assertionContent = this.templateRegistry.getTemplate(type).getContent();
        } else if (fieldOrProperty.isPrimitiveType()) {
            Template.Type type = fieldOrProperty.isPrimitiveWrapperType() ? Template.Type.HAS_FOR_PRIMITIVE_WRAPPER : Template.Type.HAS_FOR_PRIMITIVE;
            assertionContent = this.templateRegistry.getTemplate(type).getContent();
        }
        return assertionContent;
    }

    private Template.Type determinePredicateType(DataDescription fieldOrProperty, ClassDescription classDescription) {
        if (this.hasAlreadyNegativePredicate(fieldOrProperty, classDescription)) {
            return fieldOrProperty.isPrimitiveWrapperType() ? Template.Type.IS_WRAPPER_WITHOUT_NEGATION : Template.Type.IS_WITHOUT_NEGATION;
        }
        return fieldOrProperty.isPrimitiveWrapperType() ? Template.Type.IS_WRAPPER : Template.Type.IS;
    }

    private boolean hasAlreadyNegativePredicate(DataDescription fieldOrProperty, ClassDescription classDescription) {
        for (GetterDescription getterDescription : classDescription.getGettersDescriptions()) {
            if (!getterDescription.getOriginalMember().getName().equals(fieldOrProperty.getNegativePredicate())) continue;
            return true;
        }
        return false;
    }

    private String declareExceptions(GetterDescription getter, String assertionContent) {
        StringBuilder throwsClause = new StringBuilder();
        StringBuilder throwsJavaDoc = new StringBuilder();
        boolean first = true;
        for (TypeToken exception : getter.getExceptions()) {
            if (first) {
                throwsClause.append("throws ");
            } else {
                throwsClause.append(", ");
            }
            first = false;
            String exceptionName = ClassUtil.getTypeDeclaration(exception);
            throwsClause.append(exceptionName);
            throwsJavaDoc.append(LINE_SEPARATOR).append("   * @throws ").append(exceptionName);
            throwsJavaDoc.append(" if actual.").append("${getter}() throws one.");
        }
        if (!getter.getExceptions().isEmpty()) {
            throwsClause.append(' ');
        }
        assertionContent = assertionContent.replace(THROWS_JAVADOC, throwsJavaDoc.toString());
        assertionContent = assertionContent.replace(THROWS, throwsClause.toString());
        return assertionContent;
    }

    private void fillFile(String customAssertionContent, File assertionJavaFile) throws IOException {
        try (FileWriter fileWriter = new FileWriter(assertionJavaFile, false);){
            fileWriter.write(customAssertionContent);
        }
    }

    private File createFile(String fileContent, String fileName, String targetDirectory) throws IOException {
        File file = new File(targetDirectory, fileName);
        file.createNewFile();
        this.fillFile(fileContent, file);
        return file;
    }

    private static boolean noClassDescriptionsGiven(Set<ClassDescription> classDescriptionSet) {
        return classDescriptionSet == null || classDescriptionSet.isEmpty();
    }

    private static void buildDirectory(String directoryName) {
        File directory = new File(directoryName);
        if (!directory.exists()) {
            directory.mkdirs();
        }
    }

    @Override
    public void register(Template template) {
        this.templateRegistry.register(template);
    }
}

