/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.cube.spi;

import java.util.HashSet;
import java.util.Set;

public class Node {
    private String id;
    private Set<Node> parents;
    private Set<Node> children;

    private Node(String id) {
        this.id = id;
        this.parents = new HashSet<Node>();
        this.children = new HashSet<Node>();
    }

    public static Node from(String id) {
        return new Node(id);
    }

    public String getId() {
        return this.id;
    }

    public boolean addAsParentOf(Node node) {
        if (!this.parents.contains(node)) {
            this.parents.add(node);
            node.addAsChildOf(this);
            return true;
        }
        return false;
    }

    public boolean addAsChildOf(Node node) {
        if (!this.children.contains(node)) {
            this.children.add(node);
            node.addAsParentOf(this);
            return true;
        }
        return false;
    }

    public Set<Node> getParents() {
        return this.parents;
    }

    public boolean hasParent() {
        return this.parents.size() > 0;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Node [id=" + this.id);
        if (!this.parents.isEmpty()) {
            sb.append(", parents=" + this.nodeList(this.parents));
        }
        if (!this.children.isEmpty()) {
            sb.append(", children=" + this.nodeList(this.children));
        }
        sb.append("]");
        return sb.toString();
    }

    public String nodeList(Set<Node> nodes) {
        StringBuilder sb = new StringBuilder();
        Node[] array = nodes.toArray(new Node[0]);
        for (int i = 0; i < array.length; ++i) {
            sb.append(array[i].getId());
            if (i >= array.length - 1) continue;
            sb.append(",");
        }
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Node other = (Node)obj;
        return !(this.id == null ? other.id != null : !this.id.equals(other.id));
    }
}

