/*
 * Decompiled with CFR 0.152.
 */
package org.apidesign.html.json.impl;

import net.java.html.BrwsrCtx;
import org.apidesign.html.json.impl.Bindings;
import org.apidesign.html.json.impl.Callback;
import org.apidesign.html.json.impl.JSON;
import org.apidesign.html.json.impl.RcvrJSON;
import org.apidesign.html.json.impl.SetAndGet;
import org.apidesign.html.json.spi.FunctionBinding;
import org.apidesign.html.json.spi.JSONCall;
import org.apidesign.html.json.spi.PropertyBinding;

public abstract class PropertyBindingAccessor {
    private static PropertyBindingAccessor DEFAULT;

    protected PropertyBindingAccessor() {
        if (DEFAULT != null) {
            throw new IllegalStateException();
        }
        DEFAULT = this;
    }

    protected abstract <M> PropertyBinding newBinding(PBData<M> var1);

    protected abstract <M> FunctionBinding newFunction(FBData<M> var1);

    protected abstract JSONCall newCall(BrwsrCtx var1, RcvrJSON var2, String var3, String var4, String var5, Object var6);

    static <M> PropertyBinding create(PBData<M> d) {
        return DEFAULT.newBinding(d);
    }

    static <M> FunctionBinding createFunction(FBData<M> d) {
        return DEFAULT.newFunction(d);
    }

    static JSONCall createCall(BrwsrCtx ctx, RcvrJSON callback, String urlBefore, String urlAfter, String method, Object data) {
        return DEFAULT.newCall(ctx, callback, urlBefore, urlAfter, method, data);
    }

    static {
        JSON.initClass(PropertyBinding.class);
    }

    public static final class FBData<M> {
        public final String name;
        private final M model;
        private final Callback<M> access;

        public FBData(String name, M model, Callback<M> access) {
            this.name = name;
            this.model = model;
            this.access = access;
        }

        public void call(Object data, Object ev) {
            this.access.call(this.model, data, ev);
        }
    }

    public static final class PBData<M> {
        public final String name;
        public final boolean readOnly;
        private final M model;
        private final SetAndGet<M> access;
        private final Bindings<?> bindings;

        public PBData(Bindings<?> bindings, String name, M model, SetAndGet<M> access, boolean readOnly) {
            this.bindings = bindings;
            this.name = name;
            this.model = model;
            this.access = access;
            this.readOnly = readOnly;
        }

        public void setValue(Object v) {
            this.access.setValue(this.model, v);
        }

        public Object getValue() {
            return this.access.getValue(this.model);
        }

        public boolean isReadOnly() {
            return this.readOnly;
        }

        public Bindings getBindings() {
            return this.bindings;
        }
    }
}

